/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.module.confluence;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.connect.plugin.module.util.redirect.RedirectServlet;
import com.atlassian.plugin.connect.spi.RemotablePluginAccessor;
import com.atlassian.uri.Uri;
import com.atlassian.uri.UriBuilder;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroContentLinkParser {
    private final SettingsManager confluenceSettingsManager;
    private static final Logger log = LoggerFactory.getLogger(MacroContentLinkParser.class);

    public MacroContentLinkParser(SettingsManager confluenceSettingsManager) {
        this.confluenceSettingsManager = confluenceSettingsManager;
    }

    public String parse(RemotablePluginAccessor remotablePluginAccessor, String content, Map<String, String> macroParameters) {
        if (content == null) {
            return content;
        }
        StringBuilder processedContent = new StringBuilder();
        int lastPos = 0;
        int pos = content.indexOf("sign://");
        while (pos > -1) {
            String attr;
            processedContent.append(content.substring(lastPos, pos));
            lastPos = pos;
            String signToken = "sign://" + remotablePluginAccessor.getDisplayUrl().getAuthority();
            char prevChar = content.charAt(pos - 1);
            if ((prevChar == '\'' || prevChar == '\"') && (" src=".equals(attr = content.substring(pos - 6, pos - 1)) || "href=".equals(attr))) {
                StringBuilder url = new StringBuilder();
                for (int urlPos = pos + signToken.length(); urlPos < content.length(); ++urlPos) {
                    char urlChar = content.charAt(urlPos);
                    if (urlChar == '\'' || urlChar == '\"') {
                        String rawRelativeUrl = StringEscapeUtils.unescapeHtml((String)url.toString());
                        if (StringUtils.isBlank((String)rawRelativeUrl)) {
                            rawRelativeUrl = "/";
                        }
                        try {
                            Uri target = Uri.parse(rawRelativeUrl);
                            UriBuilder b = new UriBuilder(target);
                            b.addQueryParameters(macroParameters);
                            String urlToEmbed = RedirectServlet.getOAuthRedirectUrl(this.confluenceSettingsManager.getGlobalSettings().getBaseUrl(), remotablePluginAccessor.getKey(), b.toUri().toJavaUri());
                            processedContent.append(urlToEmbed);
                        }
                        catch (IllegalArgumentException ex) {
                            log.debug("Invalid relative URL: " + rawRelativeUrl, (Throwable)ex);
                            processedContent.append(url.toString());
                        }
                        lastPos = urlPos;
                        break;
                    }
                    url.append(urlChar);
                }
            }
            pos = content.indexOf(signToken, lastPos + 1);
        }
        processedContent.append(content.substring(lastPos));
        return processedContent.toString();
    }
}

