/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.module;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.connect.plugin.DefaultRemotablePluginAccessorFactory;
import com.atlassian.plugin.connect.plugin.UserPreferencesRetriever;
import com.atlassian.plugin.connect.plugin.license.LicenseRetriever;
import com.atlassian.plugin.connect.plugin.module.IFrameHost;
import com.atlassian.plugin.connect.plugin.module.page.PageInfo;
import com.atlassian.plugin.connect.plugin.util.EncodingUtils;
import com.atlassian.plugin.connect.plugin.util.LocaleHelper;
import com.atlassian.plugin.connect.spi.PermissionDeniedException;
import com.atlassian.plugin.connect.spi.RemotablePluginAccessor;
import com.atlassian.plugin.connect.spi.module.IFrameContext;
import com.atlassian.plugin.connect.spi.module.IFrameRenderer;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.uri.Uri;
import com.atlassian.uri.UriBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class IFrameRendererImpl
implements IFrameRenderer {
    private final TemplateRenderer templateRenderer;
    private final WebResourceManager webResourceManager;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory;
    private final IFrameHost iframeHost;
    private final Plugin acPlugin;
    private final LicenseRetriever licenseRetriever;
    private final LocaleHelper localeHelper;
    private final UserPreferencesRetriever userPreferencesRetriever;
    private final UserManager userManager;

    @Autowired
    public IFrameRendererImpl(TemplateRenderer templateRenderer, WebResourceManager webResourceManager, IFrameHost iframeHost, WebResourceUrlProvider webResourceUrlProvider, PluginRetrievalService pluginRetrievalService, DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory, UserPreferencesRetriever userPreferencesRetriever, LicenseRetriever licenseRetriever, LocaleHelper localeHelper, UserManager userManager) {
        this.licenseRetriever = licenseRetriever;
        this.localeHelper = localeHelper;
        this.userPreferencesRetriever = (UserPreferencesRetriever)Preconditions.checkNotNull((Object)userPreferencesRetriever);
        this.remotablePluginAccessorFactory = (DefaultRemotablePluginAccessorFactory)Preconditions.checkNotNull((Object)remotablePluginAccessorFactory);
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer);
        this.webResourceManager = (WebResourceManager)Preconditions.checkNotNull((Object)webResourceManager);
        this.iframeHost = (IFrameHost)Preconditions.checkNotNull((Object)iframeHost);
        this.webResourceUrlProvider = (WebResourceUrlProvider)Preconditions.checkNotNull((Object)webResourceUrlProvider);
        this.acPlugin = ((PluginRetrievalService)Preconditions.checkNotNull((Object)pluginRetrievalService)).getPlugin();
        this.userManager = userManager;
    }

    @Override
    public String render(IFrameContext iframeContext, String remoteUser) throws IOException {
        return this.render(iframeContext, "", Collections.<String, String[]>emptyMap(), remoteUser);
    }

    public void renderPage(IFrameContext iframeContext, PageInfo pageInfo, String extraPath, Map<String, String[]> queryParams, String remoteUser, Writer writer) throws IOException {
        try {
            if (!pageInfo.getCondition().shouldDisplay(Collections.emptyMap())) {
                throw new PermissionDeniedException(iframeContext.getPluginKey(), "Cannot render iframe for this page");
            }
            HashMap ctx = Maps.newHashMap(iframeContext.getIFrameParams().getAsMap());
            if (queryParams.get("width") != null) {
                iframeContext.getIFrameParams().setParam("width", queryParams.get("width")[0]);
            }
            if (queryParams.get("height") != null) {
                iframeContext.getIFrameParams().setParam("height", queryParams.get("height")[0]);
            }
            ctx.put("queryParams", this.contextQueryParameters(queryParams));
            ctx.put("title", pageInfo.getTitle());
            ctx.put("contextPath", this.iframeHost.getContextPath());
            ctx.put("iframeHtml", this.render(iframeContext, extraPath, queryParams, remoteUser));
            ctx.put("decorator", pageInfo.getDecorator());
            for (Map.Entry<String, String> metaTag : pageInfo.getMetaTagsContent().entrySet()) {
                ctx.put(metaTag.getKey(), metaTag.getValue());
            }
            this.templateRenderer.render("velocity/iframe-page" + pageInfo.getTemplateSuffix() + ".vm", (Map)ctx, writer);
        }
        catch (PermissionDeniedException ex) {
            this.templateRenderer.render("velocity/iframe-page-accessdenied" + pageInfo.getTemplateSuffix() + ".vm", (Map)ImmutableMap.of((Object)"title", (Object)pageInfo.getTitle(), (Object)"decorator", (Object)pageInfo.getDecorator()), writer);
        }
    }

    @Override
    public String render(IFrameContext iframeContext, String extraPath, Map<String, String[]> queryParams, String remoteUser) throws IOException {
        RemotablePluginAccessor remotablePluginAccessor = this.remotablePluginAccessorFactory.get(iframeContext.getPluginKey());
        URI hostUrl = this.iframeHost.getUrl();
        UriBuilder uriBuilder = new UriBuilder(Uri.parse(iframeContext.getIframePath()));
        uriBuilder.setPath(uriBuilder.getPath() + ObjectUtils.toString((Object)extraPath));
        URI iframeUrl = uriBuilder.toUri().toJavaUri();
        String[] dialog = queryParams.get("dialog");
        String timeZone = this.userPreferencesRetriever.getTimeZoneFor(remoteUser).getID();
        UserProfile user = this.userManager.getUserProfile(remoteUser);
        HashMap allParams = Maps.newHashMap(queryParams);
        allParams.put("user_id", new String[]{remoteUser});
        allParams.put("user_key", new String[]{user == null ? "" : user.getUserKey().getStringValue()});
        allParams.put("xdm_e", new String[]{hostUrl.toString()});
        allParams.put("xdm_c", new String[]{"channel-" + iframeContext.getNamespace()});
        allParams.put("xdm_p", new String[]{"1"});
        allParams.put("cp", new String[]{this.iframeHost.getContextPath()});
        allParams.put("tz", new String[]{timeZone});
        allParams.put("loc", new String[]{this.localeHelper.getLocaleTag()});
        allParams.put("lic", new String[]{this.licenseRetriever.getLicenseStatus(iframeContext.getPluginKey()).value()});
        if (dialog != null && dialog.length == 1) {
            allParams.put("dialog", dialog);
        }
        String signedUrl = remotablePluginAccessor.signGetUrl(iframeUrl, allParams);
        signedUrl = new UriBuilder(Uri.parse(signedUrl)).removeQueryParameter("xdm_e").removeQueryParameter("xdm_c").removeQueryParameter("xdm_p").toString();
        HashMap ctx = Maps.newHashMap(iframeContext.getIFrameParams().getAsMap());
        ctx.put("iframeSrcHtml", EncodingUtils.escapeQuotes(signedUrl));
        ctx.put("plugin", remotablePluginAccessor);
        ctx.put("namespace", iframeContext.getNamespace());
        ctx.put("contextPath", this.iframeHost.getContextPath());
        ctx.put("userId", remoteUser == null ? "" : remoteUser);
        ctx.put("userKey", user == null ? "" : user.getUserKey().getStringValue());
        ctx.put("data", ImmutableMap.of((Object)"timeZone", (Object)timeZone));
        if (dialog != null && dialog.length == 1) {
            ctx.put("dialog", dialog[0]);
        }
        StringWriter output = new StringWriter();
        this.templateRenderer.render("velocity/iframe-body.vm", (Map)ctx, (Writer)output);
        return output.toString();
    }

    private Map<String, List<String>> contextQueryParameters(Map<String, String[]> queryParams) {
        HashMap ctxQueryParams = Maps.newHashMap();
        for (Map.Entry<String, String[]> param : queryParams.entrySet()) {
            ctxQueryParams.put(param.getKey(), Arrays.asList((Object[])param.getValue()));
        }
        return ctxQueryParams;
    }
}

