/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.integration.plugins;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import org.springframework.beans.factory.DisposableBean;

public class StartableForPlugins
implements LifecycleAware,
DisposableBean {
    private final Multimap<String, Runnable> runnables = ArrayListMultimap.create();
    private boolean started = false;
    private final PluginEventManager pluginEventManager;
    private final PluginAccessor pluginAccessor;

    public StartableForPlugins(PluginEventManager pluginEventManager, PluginAccessor pluginAccessor) {
        this.pluginEventManager = pluginEventManager;
        this.pluginAccessor = pluginAccessor;
        pluginEventManager.register((Object)this);
    }

    public synchronized void register(String pluginKey, Runnable runnable) {
        if (this.pluginAccessor.isPluginEnabled(pluginKey)) {
            runnable.run();
        } else {
            this.runnables.put((Object)pluginKey, (Object)runnable);
        }
    }

    public synchronized void onStart() {
        this.started = true;
        for (String key : this.runnables.keySet()) {
            this.runRunnablesForPlugin(key);
        }
    }

    private void runRunnablesForPlugin(String key) {
        if (this.runnables.containsKey((Object)key) && this.pluginAccessor.isPluginEnabled(key)) {
            for (Runnable runnable : this.runnables.get((Object)key)) {
                runnable.run();
            }
            this.runnables.removeAll((Object)key);
        }
    }

    @PluginEventListener
    public synchronized void onPluginEnabledEvent(PluginEnabledEvent event) {
        if (this.started) {
            this.runRunnablesForPlugin(event.getPlugin().getKey());
            this.runnables.removeAll((Object)event.getPlugin().getKey());
        }
    }

    public void destroy() throws Exception {
        this.pluginEventManager.unregister((Object)this);
    }

    public synchronized void unregister(String key) {
        this.runnables.removeAll((Object)key);
    }
}

