/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.installer;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.connect.plugin.OAuthLinkManager;
import com.atlassian.plugin.connect.plugin.event.RemoteEventsHandler;
import com.atlassian.plugin.connect.plugin.installer.ConnectAddOnInstaller;
import com.atlassian.plugin.connect.plugin.installer.RemotePluginArtifactFactory;
import com.atlassian.plugin.connect.spi.InstallationFailedException;
import com.atlassian.plugin.connect.spi.PermissionDeniedException;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.util.WaitUntil;
import java.util.Set;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultConnectAddOnInstaller
implements ConnectAddOnInstaller {
    private final RemotePluginArtifactFactory remotePluginArtifactFactory;
    private final PluginController pluginController;
    private final PluginAccessor pluginAccessor;
    private final OAuthLinkManager oAuthLinkManager;
    private final RemoteEventsHandler remoteEventsHandler;
    private static final Logger log = LoggerFactory.getLogger(DefaultConnectAddOnInstaller.class);

    @Autowired
    public DefaultConnectAddOnInstaller(RemotePluginArtifactFactory remotePluginArtifactFactory, PluginController pluginController, PluginAccessor pluginAccessor, OAuthLinkManager oAuthLinkManager, RemoteEventsHandler remoteEventsHandler) {
        this.remotePluginArtifactFactory = remotePluginArtifactFactory;
        this.pluginController = pluginController;
        this.pluginAccessor = pluginAccessor;
        this.oAuthLinkManager = oAuthLinkManager;
        this.remoteEventsHandler = remoteEventsHandler;
    }

    @Override
    public Plugin install(String username, Document document) {
        String pluginKey = "unknown";
        try {
            Plugin plugin;
            pluginKey = this.getPluginKey(document);
            this.removeOldPlugin(pluginKey);
            Plugin installedPlugin = null;
            PluginArtifact pluginArtifact = this.getPluginArtifact(username, document);
            Set pluginKeys = this.pluginController.installPlugins(new PluginArtifact[]{pluginArtifact});
            if (pluginKeys.size() == 1) {
                String installedKey = (String)pluginKeys.iterator().next();
                plugin = this.pluginAccessor.getPlugin(installedKey);
                WaitUntil.invoke((WaitUntil.WaitCondition)new WaitUntil.WaitCondition(){

                    public boolean isFinished() {
                        for (ModuleDescriptor desc : plugin.getModuleDescriptors()) {
                            if (DefaultConnectAddOnInstaller.this.pluginAccessor.isPluginModuleEnabled(desc.getCompleteKey()) || !(desc instanceof UnrecognisedModuleDescriptor)) continue;
                            return false;
                        }
                        return true;
                    }

                    public String getWaitMessage() {
                        return "Waiting for all module descriptors to be resolved and enabled";
                    }
                });
                if (!this.pluginAccessor.isPluginEnabled(plugin.getKey())) {
                    String cause = "Plugin didn't install correctly";
                    for (ModuleDescriptor descriptor : plugin.getModuleDescriptors()) {
                        if (!(descriptor instanceof UnloadableModuleDescriptor)) continue;
                        cause = ((UnloadableModuleDescriptor)descriptor).getErrorText();
                        break;
                    }
                    throw new RuntimeException(cause);
                }
            } else {
                throw new RuntimeException("Plugin didn't install correctly", null);
            }
            installedPlugin = plugin;
            this.remoteEventsHandler.pluginInstalled(pluginKey);
            log.info("Registered app '{}' by '{}'", (Object)pluginKey, (Object)username);
            return installedPlugin;
        }
        catch (PermissionDeniedException ex) {
            log.warn("Unable to install remote plugin '{}' by user '{}' due to permission issues: {}", new Object[]{pluginKey, username, ex.getMessage()});
            log.debug("Installation failed due to permission issue", (Throwable)ex);
            throw ex;
        }
        catch (InstallationFailedException ex) {
            log.warn("Unable to install remote plugin '{}' by user '{}' due to installation issue: {}", new Object[]{pluginKey, username, ex.getMessage()});
            log.debug("Installation failed due to installation issue", (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            log.warn("Unable to install remote plugin '{}' by user '{}'", (Object)pluginKey, (Object)username);
            log.debug("Installation failed due to unknown issue", (Throwable)e);
            throw new InstallationFailedException(e.getCause() != null ? e.getCause() : e);
        }
    }

    private PluginArtifact getPluginArtifact(String username, Document document) {
        if (document.getRootElement().attribute("plugins-version") != null) {
            return this.remotePluginArtifactFactory.create(document, username);
        }
        throw new InstallationFailedException("Missing plugins-version");
    }

    private String getPluginKey(Document document) {
        return document.getRootElement().attributeValue("key");
    }

    private void removeOldPlugin(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin != null) {
            this.pluginController.uninstall(plugin);
        } else if (this.oAuthLinkManager.isAppAssociated(pluginKey)) {
            throw new PermissionDeniedException(pluginKey, "App key '" + pluginKey + "' is already associated with an OAuth link");
        }
    }
}

