/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.installer;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.connect.plugin.descriptor.util.FormatConverter;
import com.atlassian.plugin.connect.plugin.installer.ConnectAddOnInstaller;
import com.atlassian.plugin.connect.spi.ConnectAddOnIdentifierService;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.spi.PluginInstallException;
import com.atlassian.upm.spi.PluginInstallHandler;
import com.atlassian.upm.spi.PluginInstallResult;
import java.io.File;
import org.dom4j.Document;

public class ConnectUPMInstallHandler
implements PluginInstallHandler {
    private final ConnectAddOnIdentifierService connectIdentifier;
    private final ConnectAddOnInstaller connectInstaller;
    private final UserManager userManager;
    private final FormatConverter formatConverter;

    public ConnectUPMInstallHandler(ConnectAddOnIdentifierService connectIdentifier, ConnectAddOnInstaller connectInstaller, UserManager userManager, FormatConverter formatConverter) {
        this.connectIdentifier = connectIdentifier;
        this.connectInstaller = connectInstaller;
        this.userManager = userManager;
        this.formatConverter = formatConverter;
    }

    public boolean canInstallPlugin(File descriptorFile, Option<String> contentType) {
        boolean caninstall = this.connectIdentifier.isConnectAddOn(descriptorFile);
        return caninstall;
    }

    public PluginInstallResult installPlugin(File descriptorFile, Option<String> contentType) throws PluginInstallException {
        try {
            Document doc = this.formatConverter.readFileToDoc(descriptorFile);
            Plugin plugin = this.connectInstaller.install(this.userManager.getRemoteUsername(), doc);
            return new PluginInstallResult(plugin);
        }
        catch (Exception e) {
            throw new PluginInstallException("unable to install connect add on", (Throwable)e);
        }
    }
}

