/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.connect.spi.event.product.PluginsUpgradedEvent;
import com.atlassian.plugin.connect.spi.event.product.ServerUpgradedEvent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import org.osgi.framework.BundleContext;

public class ProductEventPublisher
implements LifecycleAware {
    public static final String PLUGINS_LAST_VERSION = "plugins.lastVersion";
    private final EventPublisher eventPublisher;
    private final ApplicationProperties applicationProperties;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final BundleContext bundleContext;
    private volatile boolean started = false;

    public ProductEventPublisher(EventPublisher eventPublisher, ApplicationProperties applicationProperties, PluginSettingsFactory pluginSettingsFactory, BundleContext bundleContext) {
        this.eventPublisher = eventPublisher;
        this.applicationProperties = applicationProperties;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.bundleContext = bundleContext;
    }

    public void onStart() {
        if (!this.started) {
            String lastProductVersion = this.getLastVersion("server");
            String currentProductVersion = this.getCurrentServerVersion();
            if (!currentProductVersion.equals(lastProductVersion)) {
                this.eventPublisher.publish((Object)new ServerUpgradedEvent(lastProductVersion, currentProductVersion));
                this.saveCurrentVersion("server", currentProductVersion);
            }
            String lastVersion = this.getLastVersion("plugins");
            String currentVersion = this.getCurrentPluginsVersion();
            if (!currentVersion.equals(lastVersion)) {
                this.eventPublisher.publish((Object)new PluginsUpgradedEvent(lastVersion, currentVersion));
                this.saveCurrentVersion("plugins", currentVersion);
            }
            this.started = true;
        }
    }

    private void saveCurrentVersion(String type, String currentVersion) {
        this.pluginSettingsFactory.createGlobalSettings().put(this.getSettingsKey(type), (Object)currentVersion);
    }

    private String getSettingsKey(String type) {
        return "plugins.lastVersion." + type;
    }

    private String getCurrentServerVersion() {
        return this.applicationProperties.getBuildNumber();
    }

    private String getCurrentPluginsVersion() {
        return (String)this.bundleContext.getBundle().getHeaders().get("bundle-version");
    }

    private String getLastVersion(String type) {
        String value = (String)this.pluginSettingsFactory.createGlobalSettings().get(this.getSettingsKey(type));
        return value != null ? value : "";
    }
}

