/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.descriptor.util;

import com.atlassian.plugin.connect.plugin.descriptor.InvalidDescriptorException;
import com.atlassian.plugin.connect.plugin.descriptor.util.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.xml.sax.InputSource;

@Component
public final class FormatConverter {
    private final Set<String> appProperties = ImmutableSet.of((Object)"key", (Object)"name", (Object)"version", (Object)"display-url", (Object)"icon-url");
    private static final Logger log = LoggerFactory.getLogger(FormatConverter.class);

    public Document toDocument(String id, String contentType, String text) {
        if ("text/yaml".equals(contentType) || "application/json".equals(contentType) || id != null && (id.endsWith(".yaml") || id.endsWith(".json"))) {
            throw new InvalidDescriptorException("YAML / JSON descriptors are no longer supported!");
        }
        return this.loadAsXml(id, text);
    }

    public Document readFileToDoc(File file) {
        SAXReader reader = XmlUtils.createSecureSaxReader();
        try {
            InputSource source = new InputSource(Files.newReader((File)file, (Charset)Charsets.UTF_8));
            source.setEncoding("UTF-8");
            Document document = reader.read(file);
            document.accept((Visitor)new NamespaceCleaner());
            return document;
        }
        catch (Exception e) {
            throw new InvalidDescriptorException("Unable to parse the descriptor: " + e.getMessage(), e);
        }
    }

    private Document loadAsXml(String id, String text) {
        SAXReader reader = XmlUtils.createSecureSaxReader();
        try {
            InputSource source = new InputSource(new StringReader(text));
            source.setSystemId(id);
            source.setEncoding("UTF-8");
            Document document = reader.read(source);
            document.accept((Visitor)new NamespaceCleaner());
            return document;
        }
        catch (DocumentException e) {
            throw new InvalidDescriptorException("Unable to parse the descriptor: " + e.getMessage(), e);
        }
    }

    private void processObject(String name, Object object, Element parent) {
        if (object instanceof Map) {
            Element self = parent.addElement(name);
            for (Map.Entry entry : ((Map)object).entrySet()) {
                this.processObject((String)entry.getKey(), entry.getValue(), self);
            }
        } else if (object instanceof List) {
            for (Object entry : (List)object) {
                this.processObject(name, entry, parent);
            }
        } else if (name.equals("description") || name.equals("public-key")) {
            parent.addElement(name).setText(object.toString());
        } else {
            parent.addAttribute(name, object.toString());
        }
    }

    private static String printNode(Node document) {
        StringWriter writer = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
        try {
            xmlWriter.write(document);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to write node", e);
        }
        return writer.toString();
    }

    private static class NamespaceCleaner
    extends VisitorSupport {
        private NamespaceCleaner() {
        }

        public void visit(Document document) {
            ((DefaultElement)document.getRootElement()).setNamespace(Namespace.NO_NAMESPACE);
            document.getRootElement().additionalNamespaces().clear();
        }

        public void visit(Namespace namespace) {
            namespace.detach();
        }

        public void visit(Attribute node) {
            if (node.toString().contains("xmlns") || node.toString().contains("xsi:")) {
                node.detach();
            }
        }

        public void visit(Element node) {
            if (node instanceof DefaultElement) {
                ((DefaultElement)node).setNamespace(Namespace.NO_NAMESPACE);
            }
        }
    }
}

