/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.descriptor;

import com.atlassian.plugin.connect.plugin.descriptor.DescriptorAccessor;
import com.atlassian.plugin.connect.plugin.descriptor.InvalidDescriptorException;
import com.atlassian.plugin.connect.plugin.descriptor.util.FormatConverter;
import com.atlassian.plugin.connect.plugin.descriptor.util.XmlUtils;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.osgi.framework.Bundle;

public final class PolyglotDescriptorAccessor
implements DescriptorAccessor {
    private static final Iterable<DescriptorType> DESCRIPTOR_TYPES = ImmutableSet.of((Object)new DescriptorType("atlassian-plugin.xml", "text/xml", false));
    private final UrlProvider urlProvider;
    private final DescriptorType descriptorType;

    public PolyglotDescriptorAccessor(final Bundle bundle) {
        this.urlProvider = new UrlProvider(){

            @Override
            public URL getResource(String path) {
                return bundle.getResource(path);
            }
        };
        this.descriptorType = this.determineDescriptorType(this.urlProvider);
    }

    public PolyglotDescriptorAccessor(final File baseDir) {
        this.urlProvider = new UrlProvider(){

            @Override
            public URL getResource(String path) {
                try {
                    File file = new File(baseDir, path);
                    return file.exists() ? file.toURI().toURL() : null;
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(path);
                }
            }
        };
        this.descriptorType = this.determineDescriptorType(this.urlProvider);
    }

    @Override
    public Document getDescriptor() {
        return PolyglotDescriptorAccessor.loadDescriptor(this.urlProvider, this.descriptorType.path, this.descriptorType.contentType, this.descriptorType.convert);
    }

    @Override
    public String getKey() {
        return this.getDescriptor().getRootElement().attributeValue("key");
    }

    @Override
    public URL getDescriptorUrl() {
        return this.urlProvider.getResource(this.descriptorType.path);
    }

    private DescriptorType determineDescriptorType(UrlProvider urlProvider) {
        for (DescriptorType type : DESCRIPTOR_TYPES) {
            if (urlProvider.getResource(type.path) == null) continue;
            return type;
        }
        throw new IllegalArgumentException("No descriptor found");
    }

    static Document loadDescriptor(UrlProvider urlProvider, String path, String contentType, boolean convert) {
        URL descriptorUrl = urlProvider.getResource(path);
        if (descriptorUrl != null) {
            if (convert) {
                FormatConverter converter = new FormatConverter();
                InputStream in = null;
                try {
                    in = descriptorUrl.openStream();
                    String content = IOUtils.toString((InputStream)in);
                    Document document = converter.toDocument(path, contentType, content);
                    return document;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid path: " + path, e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            try {
                return XmlUtils.createSecureSaxReader().read(descriptorUrl);
            }
            catch (DocumentException e) {
                throw new InvalidDescriptorException("Unable to read and parse app descriptor", e);
            }
        }
        return null;
    }

    private static class DescriptorType {
        final String path;
        final String contentType;
        final boolean convert;

        private DescriptorType(String path, String contentType, boolean convert) {
            this.path = path;
            this.contentType = contentType;
            this.convert = convert;
        }
    }

    static interface UrlProvider {
        public URL getResource(String var1);
    }
}

