/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.connect.plugin.ApplicationLinkAccessor;
import com.atlassian.plugin.connect.plugin.OAuthLinkManager;
import com.atlassian.plugin.connect.plugin.util.MapFunctions;
import com.atlassian.plugin.connect.plugin.util.http.CachingHttpContentRetriever;
import com.atlassian.plugin.connect.spi.ConnectAddOnIdentifierService;
import com.atlassian.plugin.connect.spi.PermissionDeniedException;
import com.atlassian.plugin.connect.spi.RemotablePluginAccessor;
import com.atlassian.plugin.connect.spi.RemotablePluginAccessorFactory;
import com.atlassian.plugin.connect.spi.applinks.RemotePluginContainerApplicationType;
import com.atlassian.plugin.connect.spi.http.AuthorizationGenerator;
import com.atlassian.plugin.connect.spi.http.HttpMethod;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.uri.Uri;
import com.atlassian.uri.UriBuilder;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class DefaultRemotablePluginAccessorFactory
implements RemotablePluginAccessorFactory,
DisposableBean {
    private final ApplicationLinkAccessor applicationLinkAccessor;
    private final OAuthLinkManager oAuthLinkManager;
    private final CachingHttpContentRetriever httpContentRetriever;
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private final ConnectAddOnIdentifierService connectIdentifier;
    private final Map<String, RemotablePluginAccessor> accessors;

    @Autowired
    public DefaultRemotablePluginAccessorFactory(ApplicationLinkAccessor applicationLinkAccessor, OAuthLinkManager oAuthLinkManager, CachingHttpContentRetriever httpContentRetriever, PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, EventPublisher eventPublisher, ConnectAddOnIdentifierService connectIdentifier) {
        this.applicationLinkAccessor = applicationLinkAccessor;
        this.oAuthLinkManager = oAuthLinkManager;
        this.httpContentRetriever = httpContentRetriever;
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
        this.eventPublisher.register((Object)this);
        this.connectIdentifier = connectIdentifier;
        this.accessors = CopyOnWriteMap.newHashMap();
    }

    @EventListener
    public void onApplicationLinkCreated(ApplicationLinkAddedEvent event) {
        if (event.getApplicationType() instanceof RemotePluginContainerApplicationType) {
            this.accessors.clear();
        }
    }

    @EventListener
    public void onApplicationLinkRemoved(ApplicationLinkDeletedEvent event) {
        if (event.getApplicationType() instanceof RemotePluginContainerApplicationType) {
            this.accessors.remove(this.getPluginKey(event.getApplicationLink()));
        }
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.accessors.remove(event.getPlugin().getKey());
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.accessors.remove(event.getPlugin().getKey());
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.accessors.remove(event.getModule().getPluginKey());
    }

    private String getPluginKey(ApplicationLink link) {
        return String.valueOf(link.getProperty("plugin-key"));
    }

    @Override
    public RemotablePluginAccessor get(String pluginKey) {
        RemotablePluginAccessor accessor;
        if (this.accessors.containsKey(pluginKey)) {
            accessor = this.accessors.get(pluginKey);
        } else {
            accessor = this.create(pluginKey, this.getDisplayUrl(pluginKey));
            this.accessors.put(pluginKey, accessor);
        }
        return accessor;
    }

    private Supplier<URI> getDisplayUrl(String pluginKey) {
        ApplicationLink link = this.applicationLinkAccessor.getApplicationLink(pluginKey);
        if (link != null) {
            return Suppliers.ofInstance((Object)link.getDisplayUrl());
        }
        return Suppliers.compose((Function)ToUriFunction.INSTANCE, (Supplier)new Supplier<String>(){

            public String get() {
                return DefaultRemotablePluginAccessorFactory.this.applicationProperties.getBaseUrl();
            }
        });
    }

    public RemotablePluginAccessor create(String pluginKey, Supplier<URI> displayUrl) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        Preconditions.checkNotNull((Object)plugin, (String)"Plugin not found: '%s'", (Object[])new Object[]{pluginKey});
        return new OAuthSigningRemotablePluginAccessor(pluginKey, plugin.getName(), displayUrl, this.getDummyServiceProvider());
    }

    private ServiceProvider getDummyServiceProvider() {
        URI dummyUri = URI.create("http://localhost");
        return new ServiceProvider(dummyUri, dummyUri, dummyUri);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    private String executeCreateGetUrl(URI targetUrl, Map<String, String[]> params) {
        return new UriBuilder(Uri.fromJavaUri(targetUrl)).addQueryParameters(Maps.transformValues(params, MapFunctions.STRING_ARRAY_TO_STRING)).toString();
    }

    private Promise<String> executeAsyncForType(AuthorizationGenerator authorizationGenerator, HttpMethod method, URI targetUrl, Map<String, String> params, Map<String, String> headers, String pluginKey) {
        return this.httpContentRetriever.async(authorizationGenerator, method, targetUrl, Maps.transformValues(params, MapFunctions.OBJECT_TO_STRING), headers, pluginKey);
    }

    private String signGetUrlForType(ServiceProvider serviceProvider, URI targetUrl, Map<String, String[]> params) throws PermissionDeniedException {
        UriBuilder uriBuilder = new UriBuilder(Uri.fromJavaUri(targetUrl));
        for (Map.Entry<String, String> param : this.signRequest(serviceProvider, targetUrl, params, HttpMethod.GET)) {
            String value = param.getValue() == null ? "" : param.getValue();
            uriBuilder.addQueryParameter(param.getKey(), value);
        }
        return uriBuilder.toString();
    }

    private List<Map.Entry<String, String>> signRequest(ServiceProvider serviceProvider, URI url, Map<String, String[]> queryParams, HttpMethod method) {
        String timestamp = System.currentTimeMillis() / 1000L + "";
        String nonce = System.nanoTime() + "";
        String signatureMethod = "RSA-SHA1";
        String oauthVersion = "1.0";
        HashMap params = Maps.newHashMap((Map)Maps.transformValues(queryParams, (Function)new Function<String[], List<String>>(){

            public List<String> apply(String[] from) {
                return Arrays.asList(from);
            }
        }));
        params.put("oauth_signature_method", Collections.singletonList(signatureMethod));
        params.put("oauth_nonce", Collections.singletonList(nonce));
        params.put("oauth_version", Collections.singletonList(oauthVersion));
        params.put("oauth_timestamp", Collections.singletonList(timestamp));
        return this.oAuthLinkManager.signAsParameters(serviceProvider, method, url, params);
    }

    private static enum ToUriFunction implements Function<String, URI>
    {
        INSTANCE;


        public URI apply(String uri) {
            return URI.create(uri);
        }
    }

    private class OAuthAuthorizationGenerator
    implements AuthorizationGenerator {
        private final ServiceProvider serviceProvider;

        private OAuthAuthorizationGenerator(ServiceProvider serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        @Override
        @Deprecated
        public String generate(String method, URI url, Map<String, List<String>> parameters) {
            return (String)this.generate(HttpMethod.valueOf(method), url, parameters).getOrNull();
        }

        @Override
        public Option<String> generate(HttpMethod method, URI url, Map<String, List<String>> parameters) {
            return Option.option((Object)DefaultRemotablePluginAccessorFactory.this.oAuthLinkManager.generateAuthorizationHeader(method, this.serviceProvider, url, parameters));
        }
    }

    private class OAuthSigningRemotablePluginAccessor
    implements RemotablePluginAccessor {
        private final String key;
        private final String name;
        private final Supplier<URI> displayUrl;
        private final ServiceProvider serviceProvider;

        private OAuthSigningRemotablePluginAccessor(String key, String name, Supplier<URI> displayUrl, ServiceProvider serviceProvider) {
            this.key = key;
            this.name = name;
            this.displayUrl = displayUrl;
            this.serviceProvider = serviceProvider;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public URI getDisplayUrl() {
            return (URI)this.displayUrl.get();
        }

        @Override
        public String signGetUrl(URI targetPath, Map<String, String[]> params) {
            return DefaultRemotablePluginAccessorFactory.this.signGetUrlForType(this.serviceProvider, this.getTargetUrl(targetPath), params);
        }

        @Override
        public String createGetUrl(URI targetPath, Map<String, String[]> params) {
            return DefaultRemotablePluginAccessorFactory.this.executeCreateGetUrl(this.getTargetUrl(targetPath), params);
        }

        @Override
        public Promise<String> executeAsync(HttpMethod method, URI path, Map<String, String> params, Map<String, String> headers) {
            return DefaultRemotablePluginAccessorFactory.this.executeAsyncForType(new OAuthAuthorizationGenerator(this.serviceProvider), method, this.getTargetUrl(path), params, headers, this.key);
        }

        private URI getTargetUrl(URI targetPath) {
            UriBuilder uriBuilder = new UriBuilder(Uri.fromJavaUri(targetPath));
            uriBuilder.setPath(((URI)this.displayUrl.get()).toString() + uriBuilder.getPath());
            return uriBuilder.toUri().toJavaUri();
        }

        @Override
        public AuthorizationGenerator getAuthorizationGenerator() {
            return new OAuthAuthorizationGenerator(this.serviceProvider);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

