/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clientpluginsdemorefapp.rest;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@AnonymousAllowed
@Path(value="backdoor")
@Produces(value={"application/json"})
public class BackdoorResource {
    private static final Function<ServiceReference<?>, String> GET_BSN = serviceReference -> serviceReference.getBundle().getSymbolicName();
    private final BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
    private final PluginAccessor pluginAccessor;

    public BackdoorResource(@ComponentImport PluginAccessor pluginAccessor) {
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
    }

    @GET
    @Path(value="module-types")
    public Map<String, Collection<String>> getModuleTypes() {
        return this.moduleDescriptorFactories().stream().collect(Collectors.groupingBy(GET_BSN, TreeMap::new, Collectors.mapping(this::getModuleType, Collectors.toCollection(TreeSet::new))));
    }

    private String getModuleType(ServiceReference<ListableModuleDescriptorFactory> serviceReference) {
        ListableModuleDescriptorFactory moduleDescriptorFactory = (ListableModuleDescriptorFactory)this.bundleContext.getService(serviceReference);
        Iterable moduleDescriptorKeyIter = moduleDescriptorFactory.getModuleDescriptorKeys();
        List moduleDescriptorKeys = StreamSupport.stream(moduleDescriptorKeyIter.spliterator(), false).collect(Collectors.toList());
        switch (moduleDescriptorKeys.size()) {
            case 0: {
                return "(none)";
            }
            case 1: {
                return (String)moduleDescriptorKeys.get(0);
            }
        }
        return "(multiple)";
    }

    private Collection<ServiceReference<ListableModuleDescriptorFactory>> moduleDescriptorFactories() {
        try {
            return this.bundleContext.getServiceReferences(ListableModuleDescriptorFactory.class, null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Filter is invalid", e);
        }
    }

    @GET
    @Path(value="servlet-modules")
    public Map<String, Collection<String>> getServletModules() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(ServletModuleDescriptor.class).stream().collect(Collectors.groupingBy(AbstractModuleDescriptor::getPluginKey, TreeMap::new, Collectors.mapping(AbstractModuleDescriptor::getKey, Collectors.toCollection(TreeSet::new))));
    }

    @GET
    @Path(value="module/{complete-key}")
    public Object getModule(@PathParam(value="complete-key") String completeKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(completeKey);
        if (moduleDescriptor == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return ModuleDto.toDto(moduleDescriptor);
    }

    public static class ModuleDto {
        @JsonProperty
        private final String description;
        @JsonProperty
        private final String key;
        @JsonProperty
        private final String name;
        @JsonProperty
        private final String pluginKey;

        static ModuleDto toDto(ModuleDescriptor<?> moduleDescriptor) {
            return new ModuleDto(moduleDescriptor.getDescription(), moduleDescriptor.getKey(), moduleDescriptor.getName(), moduleDescriptor.getPluginKey());
        }

        @JsonCreator
        private ModuleDto(@JsonProperty(value="description") String description, @JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="pluginKey") String pluginKey) {
            this.description = description;
            this.key = key;
            this.name = name;
            this.pluginKey = pluginKey;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }
    }
}

