/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clientpluginsdemorefapp;

import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;

public class WebItemsToCSEMigrationExample
extends HttpServlet {
    private static final String CONTENT_TYPE = "text/html;charset=UTF-8";
    private static final String RESOURCE_KEY = "com.atlassian.plugins.atlassian-clientside-extensions-demo:web-items-to-cse-migration-templates";
    private static final String TEMPLATE_KEY = "W2CSEExample.page";
    private static final String WEB_ITEM_LOCATION_A = "web-item.to.cse.location.a";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final I18nResolver i18nResolver;

    public WebItemsToCSEMigrationExample(SoyTemplateRenderer soyTemplateRenderer, DynamicWebInterfaceManager webInterfaceManager, I18nResolver i18nResolver) {
        this.soyTemplateRenderer = Objects.requireNonNull(soyTemplateRenderer);
        this.webInterfaceManager = webInterfaceManager;
        this.i18nResolver = i18nResolver;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.render((ServletResponse)response, (ServletRequest)request);
    }

    private String getLabel(WebPanelModuleDescriptor panel, HttpServletRequest request, Map<String, Object> context) {
        try {
            WebLabel webLabel = panel.getWebLabel();
            if (webLabel != null) {
                return webLabel.getDisplayableLabel(request, context);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (panel.getI18nNameKey() != null) {
            return this.i18nResolver.getText(panel.getI18nNameKey());
        }
        return panel.getKey();
    }

    private void render(ServletResponse response, ServletRequest request) throws IOException, ServletException {
        response.setContentType(CONTENT_TYPE);
        ImmutableMap.Builder context = ImmutableMap.builder();
        context.put((Object)"request", (Object)request);
        ImmutableMap buildContext = context.build();
        Iterable displayableWebItems = this.webInterfaceManager.getDisplayableWebItems(WEB_ITEM_LOCATION_A, (Map)buildContext);
        List collect = this.webInterfaceManager.getDisplayableWebPanelDescriptors("atl.refapp.index", (Map)buildContext).stream().map(webPanelModuleDescriptor -> {
            ImmutableMap.Builder webPanel = ImmutableMap.builder();
            webPanel.put((Object)"html", (Object)((WebPanel)webPanelModuleDescriptor.getModule()).getHtml((Map)buildContext));
            webPanel.put((Object)"completeKey", (Object)webPanelModuleDescriptor.getCompleteKey());
            webPanel.put((Object)"key", (Object)webPanelModuleDescriptor.getKey());
            webPanel.put((Object)"label", (Object)this.getLabel((WebPanelModuleDescriptor)webPanelModuleDescriptor, (HttpServletRequest)request, (Map<String, Object>)buildContext));
            webPanel.put((Object)"weight", (Object)webPanelModuleDescriptor.getWeight());
            return webPanel.build();
        }).collect(Collectors.toList());
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"webItemsA", (Object)ImmutableList.copyOf((Iterable)displayableWebItems));
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        String jsonWebItems = ow.writeValueAsString((Object)ImmutableList.copyOf((Iterable)displayableWebItems));
        params.put((Object)"webItemsJson", (Object)jsonWebItems);
        String jsonWebPanels = ow.writeValueAsString((Object)ImmutableList.copyOf(collect));
        params.put((Object)"webPanelsJson", (Object)jsonWebPanels);
        try {
            this.soyTemplateRenderer.render((Appendable)response.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, (Map)params.build());
        }
        catch (SoyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException((Throwable)e);
        }
    }
}

