/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.depview.rest;

import com.atlassian.depview.rest.BundleBean;
import com.atlassian.depview.rest.UriGenerator;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class BundleListBean {
    @XmlAttribute
    private final Collection<BundleBean> bundles;
    @XmlElement
    private final Map<String, URI> links;

    public BundleListBean(UriGenerator uriGenerator, BundleContext bundleContext, Optional<String> query) {
        this.bundles = Arrays.stream(bundleContext.getBundles()).map(b -> new BundleBean(uriGenerator, (Bundle)b, query)).collect(Collectors.toList());
        this.links = Maps.newHashMap();
        this.links.put("plugins", uriGenerator.bundleToPlugins());
    }
}

