/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.depview.osgi;

import com.atlassian.depview.osgi.WireDirection;
import com.atlassian.depview.rest.DependencyBean;
import com.atlassian.depview.rest.ServiceBean;
import com.atlassian.depview.rest.WireBean;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class BundleExplorer {
    private final Bundle bundle;
    private final Optional<String> query;

    public BundleExplorer(@Nonnull Bundle bundle, Optional<String> query) {
        this.bundle = bundle;
        this.query = query;
    }

    public BundleExplorer(@Nonnull Bundle bundle) {
        this(bundle, Optional.empty());
    }

    private String getResolutionType(Map<String, String> resolutionDirectives) {
        return Optional.ofNullable(resolutionDirectives.get("resolution")).orElse("mandatory");
    }

    private Stream<BundleRevision> revisionStream() {
        return Optional.ofNullable(this.bundle.adapt(BundleRevisions.class)).map(BundleRevisions::getRevisions).orElse(Collections.emptyList()).stream();
    }

    public Collection<WireBean> getDeclaredRequirements() {
        return this.revisionStream().flatMap(br -> br.getDeclaredRequirements(null).stream()).map(req -> {
            Map resolutionDirectives = req.getDirectives();
            String namespace = req.getNamespace();
            Object value = req.getAttributes().get(namespace);
            return new WireBean(namespace, value, this.bundle.getBundleId(), resolutionDirectives, this.getResolutionType(resolutionDirectives), req.toString());
        }).collect(Collectors.toList());
    }

    public Collection<WireBean> getDeclaredCapabilities() {
        return this.revisionStream().flatMap(br -> br.getDeclaredCapabilities(null).stream()).map(cap -> {
            Map resolutionDirectives = cap.getDirectives();
            String namespace = cap.getNamespace();
            Object value = cap.getAttributes().get(namespace);
            return new WireBean(namespace, value, this.bundle.getBundleId(), resolutionDirectives, this.getResolutionType(resolutionDirectives), cap.toString());
        }).collect(Collectors.toList());
    }

    public Collection<WireBean> getWires(WireDirection direction) {
        return this.revisionStream().map(BundleRevision::getWiring).filter(bw -> bw != null && bw.isInUse()).flatMap(bw -> direction.getWires((BundleWiring)bw).stream()).map(wire -> {
            Long bundleId = direction.getBundle((BundleWire)wire).getBundleId();
            Map resolutionDirectives = wire.getRequirement().getDirectives();
            String namespace = wire.getRequirement().getNamespace();
            Object value = null;
            BundleCapability capability = wire.getCapability();
            if (capability != null && capability.getAttributes().containsKey(namespace)) {
                value = capability.getAttributes().get(namespace);
            }
            return new WireBean(namespace, value, bundleId, resolutionDirectives, this.getResolutionType(resolutionDirectives), wire.toString());
        }).filter(wb -> this.query.map(q -> wb.getNamespace().equals("osgi.wiring.package") && wb.getValue().toString().startsWith((String)q)).orElse(true)).collect(Collectors.toList());
    }

    public Collection<ServiceBean> getServices(WireDirection direction) {
        return Optional.ofNullable(direction.getServices(this.bundle)).map(r -> Arrays.stream(r).filter(this::filterServiceReference).map(ServiceBean::new).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private boolean filterServiceReference(ServiceReference serviceReference) {
        return this.query.map(q -> {
            String[] serviceInterfaces = (String[])serviceReference.getProperty("objectClass");
            return Arrays.stream(serviceInterfaces).anyMatch(i -> i.startsWith((String)q));
        }).orElse(true);
    }

    public Collection<DependencyBean> getDependencies() {
        ImmutableSetMultimap.Builder byBundleId = ImmutableSetMultimap.builder();
        this.getWires(WireDirection.REQUIRED).stream().forEach(w -> byBundleId.put((Object)w.getBundleId(), (Object)w.getResolutionType()));
        return byBundleId.build().asMap().entrySet().stream().map(e -> new DependencyBean((Long)e.getKey(), new HashSet<String>((Collection)e.getValue()))).collect(Collectors.toList());
    }
}

