package com.atlassian.depview.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;

import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;

public class DepviewServlet extends HttpServlet {

    private static final String PLUGIN_VIEWER_TEMPLATE = "/templates/plugin-viewer.vm";
    private static final String MODULE_VIEWER_TEMPLATE = "/templates/module-viewer.vm";

    private final PageBuilderService pageBuilderService;

    private final TemplateRenderer templateRenderer;

    private final UserManager userManager;

    private final LoginUriProvider loginUriProvider;

    @Inject
    public DepviewServlet(final PageBuilderService pageBuilderService, final TemplateRenderer templateRenderer, final UserManager userManager, final LoginUriProvider loginUriProvider) {
        this.pageBuilderService = pageBuilderService;
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = userManager.getRemoteUser(req);
        if (user == null || !userManager.isAdmin(user.getUserKey())) {
            redirectToLogin(req, resp);
            return;
        }

        resp.setContentType("text/html; charset=utf-8");

        if (req.getRequestURI().endsWith("/plugins")) {
            templateRenderer.render(PLUGIN_VIEWER_TEMPLATE, resp.getWriter());
            pageBuilderService.assembler().resources().requireWebResource("com.atlassian.plugins-viewer-plugin:plugin-viewer-resources");
        } else if (req.getRequestURI().endsWith("/modules")) {
            pageBuilderService.assembler().resources().requireWebResource("com.atlassian.plugins-viewer-plugin:module-viewer-resources");
            templateRenderer.render(MODULE_VIEWER_TEMPLATE, resp.getWriter());
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(loginUriProvider.getLoginUri(getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}
