package com.atlassian.depview.rest;


import javax.xml.bind.annotation.XmlAttribute;
import java.util.Map;

public class WireBean {
    @XmlAttribute
    final String namespace;

    @XmlAttribute
    final Object value;

    @XmlAttribute
    final Long bundleId;

    @XmlAttribute
    final Map<String, String> resolutionDirectives;

    @XmlAttribute
    final String resolutionType;

    @XmlAttribute
    final String description;

    public WireBean(final String namespace, final Object value, final Long bundleId, final Map<String, String> resolutionDirectives, final String resolutionType, final String description) {
        this.namespace = namespace;
        this.value = value;
        this.bundleId = bundleId;
        this.resolutionDirectives = resolutionDirectives;
        this.resolutionType = resolutionType;
        this.description = description;
    }

    public Long getBundleId() {
        return bundleId;
    }

    public String getResolutionType() {
        return resolutionType;
    }

    public Object getValue() {
        return value;
    }

    public String getNamespace() {
        return namespace;
    }
}
