package com.atlassian.depview.rest;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;

import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;

public class UriGenerator {
    private final ApplicationProperties applicationProperties;

    private final static String restPath = "/rest/depview/1.0/";

    private final AtomicReference<String> baseUrl = new AtomicReference<>();

    @Inject
    public UriGenerator(final ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    private String getBaseUrl() {
        if (baseUrl.get() == null) {
            baseUrl.compareAndSet(null, applicationProperties.getBaseUrl(UrlMode.RELATIVE) + restPath);

        }
        return baseUrl.get();
    }

    public URI bundleToPlugins() {
        return UriBuilder.fromPath(getBaseUrl())
                .path(BundlesResource.class)
                .path(BundlesResource.class, "getToPlugins")
                .build();
    }

    private URI bundleLink(final Long bundleId, final String method) {
        return UriBuilder.fromPath(getBaseUrl())
                .path(BundlesResource.class)
                .path(BundlesResource.class, method)
                .build(bundleId);
    }

    private String firstCap(final String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public URI bundle(final Long bundleId) {
        return bundleLink(bundleId, "getBundle");
    }

    public URI bundleInfo(final Long bundleId, final String info) {
        return bundleLink(bundleId, "get" + firstCap(info));
    }
}
