package com.atlassian.depview.rest;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import java.util.Set;

@XmlAccessorType(XmlAccessType.FIELD)
public class DependencyBean {
    @XmlAttribute
    private final long bundleId;

    @XmlElement()
    private final Set<String> resolutionTypes;

    public DependencyBean(final long bundleId, final Set<String> resolutionTypes) {
        this.bundleId = bundleId;
        this.resolutionTypes = resolutionTypes;
    }

    public Set<String> getResolutionTypes() {
        return resolutionTypes;
    }
}
