AJS.namespace("Atlassian.Notifications.RecipientModel");
AJS.namespace("Atlassian.Notifications.RecipientCollection");

Atlassian.Notifications.RecipientModel = Backbone.Model.extend({

    properties: ["id", "type", "name", "individual", "serverId", "paramValue", "paramDisplay"],

    initialize: function () {
        _.bindAll(this);
    },

    getKey: function () {
        var recipientKey = this.get("individual") ? this.get("type") : this.get("serverId");
        if (this.get("paramValue") !== undefined) {
            recipientKey += "_" + this.get("paramValue");
        }
        return recipientKey;
    },

    parse: function (resp) {
        return {
            id: resp.id,
            type: resp.type,
            name: resp.name,
            individual: resp.individual,
            serverId: resp.serverId,
            paramValue: resp.paramValue,
            paramDisplay: resp.paramDisplay
        };
    }
});

Atlassian.Notifications.RecipientCollection = Backbone.Collection.extend({
    model: Atlassian.Notifications.RecipientModel
});
