AJS.namespace("Atlassian.Notifications.NotificationsView");

Atlassian.Notifications.NotificationsView = Backbone.View.extend({
    tagName:"table",
    className:"aui notifications",

    events:{
        "click .delete-lnk":"handleDelete",
        "click .edit-lnk":"handleEdit"
    },

    template:Atlassian.Templates.Notifications.notificationRow,

    initialize:function() {
        _.bindAll(this);
    },

    showPlaceHolder:function() {
        this.$tbody.find(".placeholder").removeClass("hidden");
    },

    hidePlaceHolder:function() {
        this.$tbody.find(".placeholder").addClass("hidden");
    },

    handleDelete:function(e) {
        var that = this;
        if(confirm(AJS.I18n.getText("notifications.plugin.confirm.delete"))) {
            AJS.$("#scheme-admin .throbber").addClass("loading");
            var notificationId = AJS.$(e.target).attr("rel");
            var notificationModel = this.model.get(notificationId);
            notificationModel.destroy({
                success:function() {
                    that.$el.find("#notification-" + notificationId).remove();
                },
                error:function() {
                    alert(AJS.I18n.getText("notifications.plugin.unknown.error"));
                },
                complete:function() {
                    AJS.$("#scheme-admin .throbber").removeClass("loading");
                }
            });
        }

    },

    handleEdit:function(e) {
        var notificationId = AJS.$(e.target).attr("rel");
        var notificationModel = this.model.get(notificationId);

        //create a deep copy
        var editNotificationModel = notificationModel.clone();
        editNotificationModel.set({
            recipients:new Atlassian.Notifications.RecipientCollection(notificationModel.get("recipients").models),
            events:new Atlassian.Notifications.EventCollection(notificationModel.get("events").models)
        });

        var editModel = new Atlassian.Notifications.AddNotificationModel({
            schemeId:this.model.get("id"),
            notification:editNotificationModel
        });
        //chain the event to the real notifiationModel so that the main view can update!
        editNotificationModel.on("saveSuccess", function() {
            notificationModel.trigger("saveSuccess");
        });

        var editView = new Atlassian.Notifications.AddNotificationView({model:editModel}, {update:true});
        editView.showThrobber();
        editModel.on("optionsFetched", function() {
            editView.render();
        });

        editModel.fetchOptions();
    },

    addOne:function(notificationModel) {
        var $row = AJS.$(this.template({notification:notificationModel.toJSON()}));
        var recipientView = new Atlassian.Notifications.NotificationRecipientView({model:notificationModel.get("recipients")});
        var eventsView = new Atlassian.Notifications.NotificationEventView({model:notificationModel.get("events")});
        $row.find(".recipient").append(recipientView.render());
        $row.find(".events").append(eventsView.render());
        this.$tbody.append($row);
    },

    addAll:function(notifications) {
        if(notifications.length === 0) {
            this.showPlaceHolder();
        } else {
            this.hidePlaceHolder();
            notifications.each(this.addOne);
        }
    },

    render:function() {
        this.$el.empty();
        this.$el.append(Atlassian.Templates.Notifications.notificationHeader());
        this.$tbody = this.$el.find("tbody");
        this.addAll(this.model);
        this.$el.append(this.$tbody);

        return this.$el;
    }
});