/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.dispatcher;

import com.atlassian.plugin.notifications.api.event.NotificationEvent;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.recipient.GroupRecipient;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.plugin.notifications.api.queue.NotificationQueueManager;
import com.atlassian.plugin.notifications.api.queue.NotificationTask;
import com.atlassian.plugin.notifications.api.queue.TaskStatus;
import com.atlassian.plugin.notifications.dispatcher.NotificationQueueMonitor;
import com.atlassian.plugin.notifications.dispatcher.SingleServerPreferences;
import com.atlassian.plugin.notifications.dispatcher.TaskComponents;
import com.atlassian.plugin.notifications.dispatcher.UserRecipientPreferences;
import com.atlassian.plugin.notifications.dispatcher.task.AddressesNotificationTask;
import com.atlassian.plugin.notifications.dispatcher.task.GroupNotificationTask;
import com.atlassian.plugin.notifications.dispatcher.task.IndividualNotificationTask;
import com.atlassian.plugin.notifications.dispatcher.task.NotificationTaskProducer;
import com.atlassian.plugin.notifications.dispatcher.util.SystemPropertiesUtil;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;

public class NotificationQueueManagerImpl
implements NotificationQueueManager,
DisposableBean,
NotificationQueueMonitor {
    private static final Logger log = Logger.getLogger(NotificationQueueManagerImpl.class);
    @VisibleForTesting
    static final String PROPERTY_NOTIFICATIONS_QUEUE_MAX_SIZE = "notifications.queue.max.size";
    private static final String PROPERTY_NOTIFICATIONS_MAX_RESEND_COUNT = "notifications.max.resend.count";
    private static final String PROPERTY_SENDER_THREAD_COUNT = "notifications.sender.thread.count";
    private static final String PROPERTY_NOTIFICATIONS_DELAY_SIZE_PER_FAILURE = "notifications.delay.per.failure";
    private TaskComponents components;
    private ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;
    private final ScheduledThreadPoolExecutor notificationSenders;
    private final int maxQueueSize;
    private final int maxResendCount;
    private final int senderThreadCount = SystemPropertiesUtil.parseSystemProperty("notifications.sender.thread.count", 3);
    private final int delaySizePerFailure;
    private final ConcurrentMap<String, NotificationTask> queue;

    public NotificationQueueManagerImpl() {
        this.maxResendCount = SystemPropertiesUtil.parseSystemProperty(PROPERTY_NOTIFICATIONS_MAX_RESEND_COUNT, 5);
        this.maxQueueSize = SystemPropertiesUtil.parseSystemProperty(PROPERTY_NOTIFICATIONS_QUEUE_MAX_SIZE, 1000);
        this.delaySizePerFailure = SystemPropertiesUtil.parseSystemProperty(PROPERTY_NOTIFICATIONS_DELAY_SIZE_PER_FAILURE, 120);
        this.queue = new ConcurrentHashMap<String, NotificationTask>(this.maxQueueSize);
        this.notificationSenders = new ScheduledThreadPoolExecutor(this.senderThreadCount, ThreadFactories.namedThreadFactory((String)"NotificationSender", (ThreadFactories.Type)ThreadFactories.Type.DAEMON), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!(r instanceof NotificationTask)) {
                    throw new RejectedExecutionException();
                }
                NotificationTask notificationTask = (NotificationTask)r;
                NotificationQueueManagerImpl.this.taskError(notificationTask);
            }
        });
    }

    public void setComponents(TaskComponents components) {
        this.components = components;
    }

    public void setThreadLocalDelegateExecutorFactory(ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.threadLocalDelegateExecutorFactory = threadLocalDelegateExecutorFactory;
    }

    @Override
    public void processEvent(Object event) {
        if (!this.components.getServerConfigurationManager().getNotificationStatus().isEnabled()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Notifications are currently disabled. Event '%s' will not be sent to any recipients.", ToStringBuilder.reflectionToString((Object)event)));
            }
            return;
        }
        int queueSize = this.queue.size();
        if (queueSize >= this.maxQueueSize) {
            this.components.getErrorRegistry().getLogger().error((Object)String.format("Notification Queue is full (%d/%d max). Try setting a higher maximum size '%s'.  Ignoring notification event '%s'.", queueSize, this.maxQueueSize, PROPERTY_NOTIFICATIONS_QUEUE_MAX_SIZE, ToStringBuilder.reflectionToString((Object)event)));
        } else {
            this.notificationSenders.submit(this.wrap(new NotificationTaskProducer(this.components, event)));
        }
    }

    private Runnable wrap(Runnable task) {
        return this.threadLocalDelegateExecutorFactory.createRunnable(task);
    }

    @Override
    public void submitIndividualNotification(Iterable<RoleRecipient> recipients, NotificationEvent event) {
        if (!this.components.getServerConfigurationManager().getNotificationStatus().isEnabled()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Notifications are currently disabled. Event '%s' will not be sent to any recipients.", ToStringBuilder.reflectionToString((Object)event)));
            }
            return;
        }
        IndividualNotificationTask task = new IndividualNotificationTask(this.components, recipients, event, new UserRecipientPreferences(this.components.getUserServerManager(), this.components.getNotificationPreferencesManager()));
        task.setState(TaskStatus.State.QUEUED);
        this.notificationSenders.submit(this.wrap(task));
    }

    @Override
    public void submitIndividualNotificationViaAddress(Iterable<NotificationAddress> address, NotificationEvent event) {
        if (!this.components.getServerConfigurationManager().getNotificationStatus().isEnabled()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Notifications are currently disabled. Event '%s' will not be sent to any recipients.", ToStringBuilder.reflectionToString((Object)event)));
            }
            return;
        }
        AddressesNotificationTask task = new AddressesNotificationTask(address, this.components, event);
        task.setState(TaskStatus.State.QUEUED);
        this.notificationSenders.submit(this.wrap(task));
    }

    @Override
    public void submitIndividualNotificationViaServer(Iterable<RoleRecipient> recipients, NotificationEvent event, int serverId) {
        if (!this.components.getServerConfigurationManager().getNotificationStatus().isEnabled()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Notifications are currently disabled. Event '%s' will not be sent to any recipients.", ToStringBuilder.reflectionToString((Object)event)));
            }
            return;
        }
        IndividualNotificationTask task = new IndividualNotificationTask(this.components, recipients, event, new SingleServerPreferences(this.components.getServerManager(), serverId));
        task.setState(TaskStatus.State.QUEUED);
        this.notificationSenders.submit(this.wrap(task));
    }

    @Override
    public void submitGroupNotification(GroupRecipient recipient, NotificationEvent event) {
        if (!this.components.getServerConfigurationManager().getNotificationStatus().isEnabled()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Notifications are currently disabled. Event '%s' will not be sent to any recipients.", ToStringBuilder.reflectionToString((Object)event)));
            }
            return;
        }
        GroupNotificationTask task = new GroupNotificationTask(this.components, recipient, event);
        task.setState(TaskStatus.State.QUEUED);
        this.notificationSenders.submit(this.wrap(task));
    }

    @Override
    public void clear() {
        BlockingQueue<Runnable> taskQueue = this.notificationSenders.getQueue();
        for (Runnable runnable : taskQueue) {
            this.notificationSenders.remove(runnable);
        }
        this.queue.clear();
    }

    public void destroy() throws Exception {
        this.notificationSenders.shutdownNow();
    }

    @Override
    public List<NotificationTask> getQueuedTasks() {
        return Lists.newArrayList(this.queue.values());
    }

    @Override
    public void taskAdded(NotificationTask task) {
        this.queue.putIfAbsent(task.getId(), task);
    }

    @Override
    public void taskCompleted(NotificationTask task) {
        this.queue.remove(task.getId());
        this.components.getErrorRegistry().removeTaskErrors(task.getId());
    }

    @Override
    public void taskError(NotificationTask task) {
        if (task.getSendCount() < this.maxResendCount) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Queueing for resend [" + task.getSendCount() + "]: " + ToStringBuilder.reflectionToString((Object)task.getEvent())));
            }
            long delayInSeconds = this.calculateDelayInSeconds(task);
            long nextAttemptTime = System.currentTimeMillis() + delayInSeconds * 1000L;
            this.notificationSenders.schedule(task, delayInSeconds, TimeUnit.SECONDS);
            task.setQueuedForRetry(nextAttemptTime);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Giving up trying to resend: " + ToStringBuilder.reflectionToString((Object)task.getEvent())));
            }
            this.queue.remove(task.getId());
        }
    }

    private long calculateDelayInSeconds(NotificationTask task) {
        return task.getSendCount() * this.delaySizePerFailure;
    }
}

