/*
 Chance.js 0.5.4
 http://chancejs.com
 (c) 2013 Victor Quinn
 Chance may be freely distributed or modified under the MIT license.
*/
'use strict';(function(k){define("atlassian/libs/chance-0.5.4",function(){var e={document:{}};k(e);return"undefined"!==typeof exports?module.exports:e.Chance})})(function(k){(function(){function e(a,c){a||(a={});if(!c)return a;for(var d in c)"undefined"===typeof a[d]&&(a[d]=c[d]);return a}function h(a,c){if(a)throw new RangeError(c);}var b=function(a){void 0!==a&&("function"===typeof a?this.random=a:this.seed=a);"undefined"===typeof this.random&&(this.mt=this.mersenne_twister(a),this.random=function(){return this.mt.random(this.seed)})};
b.prototype.bool=function(a){a=e(a,{likelihood:50});h(0>a.likelihood||100<a.likelihood,"Chance: Likelihood accepts values from 0 to 100.");return 100*this.random()<a.likelihood};b.prototype.character=function(a){a=e(a);h(a.alpha&&a.symbols,"Chance: Cannot specify both alpha and symbols.");var c="lower"===a.casing?"abcdefghijklmnopqrstuvwxyz":"upper"===a.casing?"ABCDEFGHIJKLMNOPQRSTUVWXYZ":"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";a=a.pool?a.pool:a.alpha?c:a.symbols?"!@#$%^\x26*()[]":
c+"0123456789!@#$%^\x26*()[]";return a.charAt(this.natural({max:a.length-1}))};b.prototype.floating=function(a){a=e(a,{fixed:4});var c=Math.pow(10,a.fixed);h(a.fixed&&a.precision,"Chance: Cannot specify both fixed and precision.");var d=9007199254740992/c,b=-d;h(a.min&&a.fixed&&a.min<b,"Chance: Min specified is out of range with fixed. Min should be, at least, "+b);h(a.max&&a.fixed&&a.max>d,"Chance: Max specified is out of range with fixed. Max should be, at most, "+d);a=e(a,{min:b,max:d});a=(this.integer({min:a.min*
c,max:a.max*c})/c).toFixed(a.fixed);return parseFloat(a)};b.prototype.integer=function(a){a=e(a,{min:-9007199254740992,max:9007199254740992});var c=Math.max(Math.abs(a.min),Math.abs(a.max));do{var d=this.natural({max:c});d=this.bool()?d:-1*d}while(d<a.min||d>a.max);return d};b.prototype.natural=function(a){a=e(a,{min:0,max:9007199254740992});h(a.min>a.max,"Chance: Min cannot be greater than Max.");return Math.floor(this.random()*(a.max-a.min+1)+a.min)};b.prototype.normal=function(a){a=e(a,{mean:0,
dev:1});var c=a.mean,d=a.dev;do{a=2*this.random()-1;var b=2*this.random()-1;b=a*a+b*b}while(1<=b);return d*a*Math.sqrt(-2*Math.log(b)/b)+c};b.prototype.string=function(a){a=e(a);var c=a.length||this.natural({min:5,max:20}),d="";a=a.pool;for(var b=0;b<c;b++)d+=this.character({pool:a});return d};b.prototype.capitalize=function(a){return a.charAt(0).toUpperCase()+a.substr(1)};b.prototype.mixin=function(a){for(var c in a)b.prototype[c]=a[c];return this};b.prototype.pick=function(a,c){return c&&1!==c?
this.shuffle(a).slice(0,c):a[this.natural({max:a.length-1})]};b.prototype.shuffle=function(a){a=a.slice(0);for(var c=[],d,b=Number(a.length),e=0;e<b;e++)d=this.natural({max:a.length-1}),c[e]=a[d],a.splice(d,1);return c};b.prototype.paragraph=function(a){a=e(a);a=a.sentences||this.natural({min:3,max:7});for(var c=[],d=0;d<a;d++)c.push(this.sentence());return c.join(" ")};b.prototype.sentence=function(a){a=e(a);a=a.words||this.natural({min:12,max:18});for(var c=[],d=0;d<a;d++)c.push(this.word());a=
c.join(" ");return a=this.capitalize(a)+"."};b.prototype.syllable=function(a){a=e(a);a=a.length||this.natural({min:2,max:3});for(var c="",d,b=0;b<a;b++)d=0===b?this.character({pool:"bcdfghjklmnprstvwzaeiou"}):-1==="bcdfghjklmnprstvwz".indexOf(d)?this.character({pool:"bcdfghjklmnprstvwz"}):this.character({pool:"aeiou"}),c+=d;return c};b.prototype.word=function(a){a=e(a);h(a.syllables&&a.length,"Chance: Cannot specify both syllables AND length.");var c=a.syllables||this.natural({min:1,max:3}),d="";
if(a.length){do d+=this.syllable();while(d.length<a.length);d=d.substring(0,a.length)}else for(a=0;a<c;a++)d+=this.syllable();return d};b.prototype.age=function(a){a=e(a);switch(a.type){case "child":a=this.natural({min:1,max:12});break;case "teen":a=this.natural({min:13,max:19});break;case "adult":a=this.natural({min:18,max:120});break;case "senior":a=this.natural({min:65,max:120});break;default:a=this.natural({min:1,max:120})}return a};b.prototype.birthday=function(a){a=e(a,{year:(new Date).getFullYear()-
this.age(a)});return this.date(a)};var m="Sophia Emma Isabella Jacob Mason Ethan Noah Olivia William Liam Jayden Michael Ava Alexander Aiden Daniel Matthew Elijah Emily James Anthony Benjamin Abigail Joshua Andrew David Joseph Logan Jackson Mia Christopher Gabriel Madison Samuel Ryan Lucas John Nathan Isaac Dylan Caleb Elizabeth Chloe Christian Landon Jonathan Carter Ella Luke Owen Brayden Avery Gavin Wyatt Addison Isaiah Aubrey Henry Eli Hunter Lily Jack Natalie Evan Sofia Jordan Nicholas Tyler Aaron Charlotte Zoey Jeremiah Julian Cameron Grace Hannah Amelia Harper Levi Lillian Brandon Angel Austin Connor Adrian Robert Samantha Charles Evelyn Victoria Thomas Brooklyn Sebastian Zoe Colton Jaxon Layla Kevin Zachary Ayden Dominic Blake Jose Hailey Oliver Justin Bentley Leah Jason Chase Ian Kaylee Anna Aaliyah Gabriella Josiah Allison Parker Xavier Nevaeh Alexis Adam Audrey Cooper Savannah Sarah Alyssa Claire Taylor Riley Camila Nathaniel Arianna Ashley Grayson Jace Brianna Carson Sophie Peyton Nolan Tristan Luis Brody Bella Khloe Genesis Alexa Juan Hudson Serenity Kylie Aubree Scarlett Bryson Carlos Stella Maya Easton Katherine Julia Damian Alex Kayden Ryder Lucy Madelyn Jesus Cole Autumn Makayla Kayla Mackenzie Micah Vincent Max Lauren Jaxson Gianna Eric Ariana Asher Hayden Faith Alexandra Melanie Sydney Bailey Caroline Naomi Morgan Kennedy Ellie Jasmine Eva Skylar Diego Kimberly Violet Molly Miles Steven Aria Ivan Jocelyn Trinity Elias Aidan Maxwell London Bryce Lydia Madeline Antonio Giovanni Reagan Timothy Bryan Piper Andrea Santiago Annabelle Maria Colin Richard Braxton Kaleb Brooke Kyle Kaden Preston Payton Miguel Jonah Paisley Paige Lincoln Ruby Nora Riley Mariah Leo Victor Brady Jeremy Mateo Brian Jaden Ashton Patrick Rylee Declan Lilly Brielle Sean Joel Gael Sawyer Alejandro Jade Marcus Destiny Leonardo Jesse Caden Jake Kaiden Nicole Mila Wesley Kendall Liliana Camden Kaitlyn Natalia Sadie Edward Brantley Jordyn Roman Vanessa Mary Mya Penelope Isabelle Alice Axel Silas Jude Grant Reese Gabrielle Hadley Katelyn Angelina Rachel Isabel Eleanor Cayden Emmanuel George Clara Brooklynn Jessica Maddox Malachi Bradley Alan Weston Elena Gage Aliyah Vivian Laila Sara Amy Devin Eliana Greyson Lyla Juliana Kenneth Mark Oscar Tanner Rylan Valeria Adriana Nicolas Makenzie Harrison Elise Mckenzie Derek Quinn Delilah Peyton Ezra Cora Kylee Tucker Emmett Avery Cody Rebecca Gracie Izabella Calvin Andres Jorge Abel Paul Abraham Kai Josephine Alaina Michelle Jennifer Collin Theodore Ezekiel Eden Omar Jayce Valentina Conner Bennett Aurora Catherine Stephanie Trevor Valerie Eduardo Peter Maximus Jayla Jaiden Willow Jameson Seth Daisy Alana Melody Hazel Kingston Summer Melissa Javier Margaret Travis Kinsley Kinley Garrett Everett Ariel Lila Graham Giselle Ryleigh Xander Haley Julianna Ivy Alivia Cristian Brynn Damien Ryker Griffin Keira Daniela Aniyah Angela Kate Londyn Corbin Myles Hayden Harmony Adalyn Luca Zane Francisco Ricardo Alexis Stephen Zayden Megan Allie Gabriela Iker Drake Alayna Lukas Presley Charlie Spencer Zion Erick Jenna Josue Alexandria Ashlyn Adrianna Jada Jeffrey Trenton Fiona Chance Norah Paxton Elliot Emery Fernando Maci Miranda Keegan Landen Ximena Amaya Manuel Amir Shane Cecilia Raymond Andre Ana Shelby Katie Hope Callie Jordan Luna Leilani Eliza Mckenna Angel Genevieve Makenna Isla Lola Danielle Chelsea Leila Tessa Adelyn Camille Mikayla Adeline Adalynn Sienna Esther Jacqueline Emerson Arabella Maggie Athena Lucia Lexi Ayla".split(" ");
b.prototype.first=function(){return this.pick(m)};b.prototype.gender=function(){return this.pick(["Male","Female"])};var n="Smith Johnson Williams Jones Brown Davis Miller Wilson Moore Taylor Anderson Thomas Jackson White Harris Martin Thompson Garcia Martinez Robinson Clark Rodriguez Lewis Lee Walker Hall Allen Young Hernandez King Wright Lopez Hill Scott Green Adams Baker Gonzalez Nelson Carter Mitchell Perez Roberts Turner Phillips Campbell Parker Evans Edwards Collins Stewart Sanchez Morris Rogers Reed Cook Morgan Bell Murphy Bailey Rivera Cooper Richardson Cox Howard Ward Torres Peterson Gray Ramirez James Watson Brooks Kelly Sanders Price Bennett Wood Barnes Ross Henderson Coleman Jenkins Perry Powell Long Patterson Hughes Flores Washington Butler Simmons Foster Gonzales Bryant Alexander Russell Griffin Diaz Hayes Myers Ford Hamilton Graham Sullivan Wallace Woods Cole West Jordan Owens Reynolds Fisher Ellis Harrison Gibson McDonald Cruz Marshall Ortiz Gomez Murray Freeman Wells Webb Simpson Stevens Tucker Porter Hunter Hicks Crawford Henry Boyd Mason Morales Kennedy Warren Dixon Ramos Reyes Burns Gordon Shaw Holmes Rice Robertson Hunt Black Daniels Palmer Mills Nichols Grant Knight Ferguson Rose Stone Hawkins Dunn Perkins Hudson Spencer Gardner Stephens Payne Pierce Berry Matthews Arnold Wagner Willis Ray Watkins Olson Carroll Duncan Snyder Hart Cunningham Bradley Lane Andrews Ruiz Harper Fox Riley Armstrong Carpenter Weaver Greene Lawrence Elliott Chavez Sims Austin Peters Kelley Franklin Lawson Fields Gutierrez Ryan Schmidt Carr Vasquez Castillo Wheeler Chapman Oliver Montgomery Richards Williamson Johnston Banks Meyer Bishop McCoy Howell Alvarez Morrison Hansen Fernandez Garza Harvey Little Burton Stanley Nguyen George Jacobs Reid Kim Fuller Lynch Dean Gilbert Garrett Romero Welch Larson Frazier Burke Hanson Day Mendoza Moreno Bowman Medina Fowler Brewer Hoffman Carlson Silva Pearson Holland Douglas Fleming Jensen Vargas Byrd Davidson Hopkins May Terry Herrera Wade Soto Walters Curtis Neal Caldwell Lowe Jennings Barnett Graves Jimenez Horton Shelton Barrett Obrien Castro Sutton Gregory McKinney Lucas Miles Craig Rodriquez Chambers Holt Lambert Fletcher Watts Bates Hale Rhodes Pena Beck Newman Haynes McDaniel Mendez Bush Vaughn Parks Dawson Santiago Norris Hardy Love Steele Curry Powers Schultz Barker Guzman Page Munoz Ball Keller Chandler Weber Leonard Walsh Lyons Ramsey Wolfe Schneider Mullins Benson Sharp Bowen Daniel Barber Cummings Hines Baldwin Griffith Valdez Hubbard Salazar Reeves Warner Stevenson Burgess Santos Tate Cross Garner Mann Mack Moss Thornton Dennis McGee Farmer Delgado Aguilar Vega Glover Manning Cohen Harmon Rodgers Robbins Newton Todd Blair Higgins Ingram Reese Cannon Strickland Townsend Potter Goodwin Walton Rowe Hampton Ortega Patton Swanson Joseph Francis Goodman Maldonado Yates Becker Erickson Hodges Rios Conner Adkins Webster Norman Malone Hammond Flowers Cobb Moody Quinn Blake Maxwell Pope Floyd Osborne Paul McCarthy Guerrero Lindsey Estrada Sandoval Gibbs Tyler Gross Fitzgerald Stokes Doyle Sherman Saunders Wise Colon Gill Alvarado Greer Padilla Simon Waters Nunez Ballard Schwartz McBride Houston Christensen Klein Pratt Briggs Parsons McLaughlin Zimmerman French Buchanan Moran Copeland Roy Pittman Brady McCormick Holloway Brock Poole Frank Logan Owen Bass Marsh Drake Wong Jefferson Park Morton Abbott Sparks Patrick Norton Huff Clayton Massey Lloyd Figueroa Carson Bowers Roberson Barton Tran Lamb Harrington Casey Boone Cortez Clarke Mathis Singleton Wilkins Cain Bryan Underwood Hogan McKenzie Collier Luna Phelps McGuire Allison Bridges Wilkerson Nash Summers Atkins".split(" ");
b.prototype.last=function(){return this.pick(n)};b.prototype.name=function(a){a=e(a);var c=this.first(),d=this.last();c=a.middle?c+" "+this.first()+" "+d:a.middle_initial?c+" "+this.character({alpha:!0,casing:"upper"})+". "+d:c+" "+d;a.prefix&&(c=this.prefix()+" "+c);return c};b.prototype.name_prefixes=function(){return[{name:"Doctor",abbreviation:"Dr."},{name:"Miss",abbreviation:"Miss"},{name:"Misses",abbreviation:"Mrs."},{name:"Mister",abbreviation:"Mr."}]};b.prototype.prefix=function(a){return this.name_prefix(a)};
b.prototype.name_prefix=function(a){a=e(a);return a.full?this.pick(this.name_prefixes()).name:this.pick(this.name_prefixes()).abbreviation};b.prototype.color=function(a){function c(a,c){return[a,a,a].join(c||"")}a=e(a,{format:this.pick(["hex","shorthex","rgb"]),grayscale:!1});var d=a.grayscale;if("hex"===a.format)return"#"+(d?c(this.hash({length:2})):this.hash({length:6}));if("shorthex"===a.format)return"#"+(d?c(this.hash({length:1})):this.hash({length:3}));if("rgb"===a.format)return d?"rgb("+c(this.natural({max:255}),
",")+")":"rgb("+this.natural({max:255})+","+this.natural({max:255})+","+this.natural({max:255})+")";throw Error('Invalid format provided. Please provide one of "hex", "shorthex", or "rgb"');};b.prototype.domain=function(a){a=e(a);return this.word()+"."+(a.tld||this.tld())};b.prototype.email=function(a){a=e(a);return this.word()+"@"+(a.domain||this.domain())};b.prototype.fbid=function(){return parseInt("10000"+this.natural({max:1E11}),10)};b.prototype.hashtag=function(){return"#"+this.word()};b.prototype.ip=
function(){return this.natural({max:255})+"."+this.natural({max:255})+"."+this.natural({max:255})+"."+this.natural({max:255})};b.prototype.ipv6=function(){for(var a="",c=0;8>c;c++)a+=this.hash({length:4})+":";return a.substr(0,a.length-1)};b.prototype.klout=function(){return this.natural({min:1,max:99})};b.prototype.tlds=function(){return"com org edu gov co.uk net io".split(" ")};b.prototype.tld=function(){return this.pick(this.tlds())};b.prototype.twitter=function(){return"@"+this.word()};b.prototype.address=
function(a){a=e(a);return this.natural({min:5,max:2E3})+" "+this.street(a)};b.prototype.areacode=function(a){a=e(a,{parens:!0});var c=this.natural({min:2,max:9}).toString()+this.natural({min:0,max:8}).toString()+this.natural({min:0,max:9}).toString();return a.parens?"("+c+")":c};b.prototype.city=function(){return this.capitalize(this.word({syllables:3}))};b.prototype.coordinates=function(a){a=e(a);return this.latitude(a)+", "+this.longitude(a)};b.prototype.latitude=function(a){a=e(a,{fixed:5});return this.floating({min:-90,
max:90,fixed:a.fixed})};b.prototype.longitude=function(a){a=e(a,{fixed:5});return this.floating({min:0,max:180,fixed:a.fixed})};b.prototype.phone=function(a){a=e(a,{formatted:!0});a.formatted||(a.parens=!1);var c=this.areacode(a).toString(),d=this.natural({min:2,max:9}).toString()+this.natural({min:0,max:9}).toString()+this.natural({min:0,max:9}).toString(),b=this.natural({min:1E3,max:9999}).toString();return a.formatted?c+" "+d+"-"+b:c+d+b};b.prototype.postal=function(){var a=this.character({pool:"XVTSRPNKLMHJGECBA"})+
this.natural({max:9})+this.character({alpha:!0,casing:"upper"}),c=this.natural({max:9})+this.character({alpha:!0,casing:"upper"})+this.natural({max:9});return a+" "+c};b.prototype.provinces=function(){return[{name:"Alberta",abbreviation:"AB"},{name:"British Columbia",abbreviation:"BC"},{name:"Manitoba",abbreviation:"MB"},{name:"New Brunswick",abbreviation:"NB"},{name:"Newfoundland and Labrador",abbreviation:"NL"},{name:"Nova Scotia",abbreviation:"NS"},{name:"Ontario",abbreviation:"ON"},{name:"Prince Edward Island",
abbreviation:"PE"},{name:"Quebec",abbreviation:"QC"},{name:"Saskatchewan",abbreviation:"SK"},{name:"Northwest Territories",abbreviation:"NT"},{name:"Nunavut",abbreviation:"NU"},{name:"Yukon",abbreviation:"YT"}]};b.prototype.province=function(a){return a&&a.full?this.pick(this.provinces()).name:this.pick(this.provinces()).abbreviation};b.prototype.radio=function(a){a=e(a,{side:"?"});switch(a.side.toLowerCase()){case "east":case "e":a="W";break;case "west":case "w":a="K";break;default:a=this.character({pool:"KW"})}return a+
this.character({alpha:!0,casing:"upper"})+this.character({alpha:!0,casing:"upper"})+this.character({alpha:!0,casing:"upper"})};b.prototype.state=function(a){return a&&a.full?this.pick(this.states()).name:this.pick(this.states()).abbreviation};b.prototype.states=function(){return[{name:"Alabama",abbreviation:"AL"},{name:"Alaska",abbreviation:"AK"},{name:"American Samoa",abbreviation:"AS"},{name:"Arizona",abbreviation:"AZ"},{name:"Arkansas",abbreviation:"AR"},{name:"Armed Forces Europe",abbreviation:"AE"},
{name:"Armed Forces Pacific",abbreviation:"AP"},{name:"Armed Forces the Americas",abbreviation:"AA"},{name:"California",abbreviation:"CA"},{name:"Colorado",abbreviation:"CO"},{name:"Connecticut",abbreviation:"CT"},{name:"Delaware",abbreviation:"DE"},{name:"District of Columbia",abbreviation:"DC"},{name:"Federated States of Micronesia",abbreviation:"FM"},{name:"Florida",abbreviation:"FL"},{name:"Georgia",abbreviation:"GA"},{name:"Guam",abbreviation:"GU"},{name:"Hawaii",abbreviation:"HI"},{name:"Idaho",
abbreviation:"ID"},{name:"Illinois",abbreviation:"IL"},{name:"Indiana",abbreviation:"IN"},{name:"Iowa",abbreviation:"IA"},{name:"Kansas",abbreviation:"KS"},{name:"Kentucky",abbreviation:"KY"},{name:"Louisiana",abbreviation:"LA"},{name:"Maine",abbreviation:"ME"},{name:"Marshall Islands",abbreviation:"MH"},{name:"Maryland",abbreviation:"MD"},{name:"Massachusetts",abbreviation:"MA"},{name:"Michigan",abbreviation:"MI"},{name:"Minnesota",abbreviation:"MN"},{name:"Mississippi",abbreviation:"MS"},{name:"Missouri",
abbreviation:"MO"},{name:"Montana",abbreviation:"MT"},{name:"Nebraska",abbreviation:"NE"},{name:"Nevada",abbreviation:"NV"},{name:"New Hampshire",abbreviation:"NH"},{name:"New Jersey",abbreviation:"NJ"},{name:"New Mexico",abbreviation:"NM"},{name:"New York",abbreviation:"NY"},{name:"North Carolina",abbreviation:"NC"},{name:"North Dakota",abbreviation:"ND"},{name:"Northern Mariana Islands",abbreviation:"MP"},{name:"Ohio",abbreviation:"OH"},{name:"Oklahoma",abbreviation:"OK"},{name:"Oregon",abbreviation:"OR"},
{name:"Pennsylvania",abbreviation:"PA"},{name:"Puerto Rico",abbreviation:"PR"},{name:"Rhode Island",abbreviation:"RI"},{name:"South Carolina",abbreviation:"SC"},{name:"South Dakota",abbreviation:"SD"},{name:"Tennessee",abbreviation:"TN"},{name:"Texas",abbreviation:"TX"},{name:"Utah",abbreviation:"UT"},{name:"Vermont",abbreviation:"VT"},{name:"Virgin Islands, U.S.",abbreviation:"VI"},{name:"Virginia",abbreviation:"VA"},{name:"Washington",abbreviation:"WA"},{name:"West Virginia",abbreviation:"WV"},
{name:"Wisconsin",abbreviation:"WI"},{name:"Wyoming",abbreviation:"WY"}]};b.prototype.street=function(a){a=e(a);var c=this.word({syllables:2});c=this.capitalize(c);return c=c+" "+(a.short_suffix?this.street_suffix().abbreviation:this.street_suffix().name)};b.prototype.street_suffix=function(){return this.pick(this.street_suffixes())};b.prototype.street_suffixes=function(){return[{name:"Avenue",abbreviation:"Ave"},{name:"Boulevard",abbreviation:"Blvd"},{name:"Center",abbreviation:"Ctr"},{name:"Circle",
abbreviation:"Cir"},{name:"Court",abbreviation:"Ct"},{name:"Drive",abbreviation:"Dr"},{name:"Extension",abbreviation:"Ext"},{name:"Glen",abbreviation:"Gln"},{name:"Grove",abbreviation:"Grv"},{name:"Heights",abbreviation:"Hts"},{name:"Highway",abbreviation:"Hwy"},{name:"Junction",abbreviation:"Jct"},{name:"Key",abbreviation:"Key"},{name:"Lane",abbreviation:"Ln"},{name:"Loop",abbreviation:"Loop"},{name:"Manor",abbreviation:"Mnr"},{name:"Mill",abbreviation:"Mill"},{name:"Park",abbreviation:"Park"},{name:"Parkway",
abbreviation:"Pkwy"},{name:"Pass",abbreviation:"Pass"},{name:"Path",abbreviation:"Path"},{name:"Pike",abbreviation:"Pike"},{name:"Place",abbreviation:"Pl"},{name:"Plaza",abbreviation:"Plz"},{name:"Point",abbreviation:"Pt"},{name:"Ridge",abbreviation:"Rdg"},{name:"River",abbreviation:"Riv"},{name:"Road",abbreviation:"Rd"},{name:"Square",abbreviation:"Sq"},{name:"Street",abbreviation:"St"},{name:"Terrace",abbreviation:"Ter"},{name:"Trail",abbreviation:"Trl"},{name:"Turnpike",abbreviation:"Tpke"},{name:"View",
abbreviation:"Vw"},{name:"Way",abbreviation:"Way"}]};b.prototype.tv=function(a){return this.radio(a)};b.prototype.zip=function(a){for(var c="",d=0;5>d;d++)c+=this.natural({max:9}).toString();if(a&&!0===a.plusfour)for(c+="-",d=0;4>d;d++)c+=this.natural({max:9}).toString();return c};b.prototype.ampm=function(){return this.bool()?"am":"pm"};b.prototype.date=function(a){var c=this.month({raw:!0});a=e(a,{year:parseInt(this.year(),10),month:c.numeric-1,day:this.natural({min:1,max:c.days}),hour:this.hour(),
minute:this.minute(),second:this.second(),millisecond:this.millisecond(),american:!0,string:!1});var d=new Date(a.year,a.month,a.day,a.hour,a.minute,a.second,a.millisecond);c=a.american?d.getMonth()+1+"/"+d.getDate()+"/"+d.getFullYear():d.getDate()+"/"+(d.getMonth()+1)+"/"+d.getFullYear();return a.string?c:d};b.prototype.hammertime=function(a){return this.date(a).getTime()};b.prototype.hour=function(a){a=e(a);return this.natural({min:1,max:a.twentyfour?24:12})};b.prototype.millisecond=function(){return this.natural({max:999})};
b.prototype.minute=b.prototype.second=function(){return this.natural({max:59})};b.prototype.month=function(a){a=e(a);var c=this.pick(this.months());return a.raw?c:c.name};b.prototype.months=function(){return[{name:"January",short_name:"Jan",numeric:"01",days:31},{name:"February",short_name:"Feb",numeric:"02",days:28},{name:"March",short_name:"Mar",numeric:"03",days:31},{name:"April",short_name:"Apr",numeric:"04",days:30},{name:"May",short_name:"May",numeric:"05",days:31},{name:"June",short_name:"Jun",
numeric:"06",days:30},{name:"July",short_name:"Jul",numeric:"07",days:31},{name:"August",short_name:"Aug",numeric:"08",days:31},{name:"September",short_name:"Sep",numeric:"09",days:30},{name:"October",short_name:"Oct",numeric:"10",days:31},{name:"November",short_name:"Nov",numeric:"11",days:30},{name:"December",short_name:"Dec",numeric:"12",days:31}]};b.prototype.second=function(){return this.natural({max:59})};b.prototype.timestamp=function(){return this.natural({min:1,max:parseInt((new Date).getTime()/
1E3,10)})};b.prototype.year=function(a){a=e(a,{min:(new Date).getFullYear()});a.max="undefined"!==typeof a.max?a.max:a.min+100;return this.natural(a).toString()};b.prototype.cc=function(a){a=e(a);var c=a.type?this.cc_type({name:a.type,raw:!0}):this.cc_type({raw:!0});a=c.prefix.split("");c=c.length-c.prefix.length-1;for(var d=0;d<c;d++)a.push(this.integer({min:0,max:9}));a.push(this.luhn_calculate(a.join("")));return a.join("")};b.prototype.cc_types=function(){return[{name:"American Express",short_name:"amex",
prefix:"34",length:15},{name:"Bankcard",short_name:"bankcard",prefix:"5610",length:16},{name:"China UnionPay",short_name:"chinaunion",prefix:"62",length:16},{name:"Diners Club Carte Blanche",short_name:"dccarte",prefix:"300",length:14},{name:"Diners Club enRoute",short_name:"dcenroute",prefix:"2014",length:15},{name:"Diners Club International",short_name:"dcintl",prefix:"36",length:14},{name:"Diners Club United States \x26 Canada",short_name:"dcusc",prefix:"54",length:16},{name:"Discover Card",short_name:"discover",
prefix:"6011",length:16},{name:"InstaPayment",short_name:"instapay",prefix:"637",length:16},{name:"JCB",short_name:"jcb",prefix:"3528",length:16},{name:"Laser",short_name:"laser",prefix:"6304",length:16},{name:"Maestro",short_name:"maestro",prefix:"5018",length:16},{name:"Mastercard",short_name:"mc",prefix:"51",length:16},{name:"Solo",short_name:"solo",prefix:"6334",length:16},{name:"Switch",short_name:"switch",prefix:"4903",length:16},{name:"Visa",short_name:"visa",prefix:"4",length:16},{name:"Visa Electron",
short_name:"electron",prefix:"4026",length:16}]};b.prototype.cc_type=function(a){a=e(a);var c=this.cc_types(),d=null;if(a.name){for(var b=0;b<c.length;b++)if(c[b].name===a.name||c[b].short_name===a.name){d=c[b];break}if(null===d)throw Error("Credit card type '"+a.name+"'' is not suppoted");}else d=this.pick(c);return a.raw?d:d.name};b.prototype.dollar=function(a){a=e(a,{max:1E4,min:0});a=this.floating({min:a.min,max:a.max,fixed:2}).toString();var c=a.split(".")[1];void 0===c?a+=".00":2>c.length&&
(a+="0");return 0>a?"-$"+a.replace("-",""):"$"+a};b.prototype.exp=function(a){a=e(a);var c={};c.year=this.exp_year();c.year===(new Date).getFullYear()?c.month=this.exp_month({future:!0}):c.month=this.exp_month();return a.raw?c:c.month+"/"+c.year};b.prototype.exp_month=function(a){a=e(a);if(a.future){do{a=this.month({raw:!0}).numeric;var c=parseInt(a,10)}while(c<(new Date).getMonth())}else a=this.month({raw:!0}).numeric;return a};b.prototype.exp_year=function(){return this.year({max:(new Date).getFullYear()+
10})};b.prototype.d4=function(){return this.natural({min:1,max:4})};b.prototype.d6=function(){return this.natural({min:1,max:6})};b.prototype.d8=function(){return this.natural({min:1,max:8})};b.prototype.d10=function(){return this.natural({min:1,max:10})};b.prototype.d12=function(){return this.natural({min:1,max:12})};b.prototype.d20=function(){return this.natural({min:1,max:20})};b.prototype.d30=function(){return this.natural({min:1,max:30})};b.prototype.d100=function(){return this.natural({min:1,
max:100})};b.prototype.rpg=function(a,c){c=e(c);if(null===a)throw Error("A type of die roll must be included");a=a.toLowerCase().split("d");var b=[];if(2!==a.length||!parseInt(a[0],10)||!parseInt(a[1],10))throw Error("Invalid format provided. Please provide #d# where the first # is the number of dice to roll, the second # is the max of each die");for(var l=a[0];0<l;l--)b[l-1]=this.natural({min:1,max:a[1]});return"undefined"!==typeof c.sum&&c.sum?b.reduce(function(a,c){return a+c}):b};b.prototype.guid=
function(a){a=a||{version:5};return this.string({pool:"ABCDEF1234567890",length:8})+"-"+this.string({pool:"ABCDEF1234567890",length:4})+"-"+a.version+this.string({pool:"ABCDEF1234567890",length:3})+"-"+this.string({pool:"AB89",length:1})+this.string({pool:"ABCDEF1234567890",length:3})+"-"+this.string({pool:"ABCDEF1234567890",length:12})};b.prototype.hash=function(a){a=e(a,{length:40,casing:"lower"});return this.string({pool:"upper"===a.casing?"0123456789ABCDEF":"0123456789abcdef",length:a.length})};
b.prototype.luhn_check=function(a){a=a.toString();return+a.substring(a.length-1)===this.luhn_calculate(+a.substring(0,a.length-1))};b.prototype.luhn_calculate=function(a){a=a.toString().split("").reverse();for(var c=0,b=0,e=a.length;e>b;++b){var g=+a[b];0===b%2&&(g*=2,9<g&&(g-=9));c+=g}return 9*c%10};b.prototype.mersenne_twister=function(a){return new f(a)};b.prototype.VERSION="0.5.4";var f=function(a){void 0===a&&(a=(new Date).getTime());this.N=624;this.M=397;this.MATRIX_A=2567483615;this.UPPER_MASK=
2147483648;this.LOWER_MASK=2147483647;this.mt=Array(this.N);this.mti=this.N+1;this.init_genrand(a)};f.prototype.init_genrand=function(a){this.mt[0]=a>>>0;for(this.mti=1;this.mti<this.N;this.mti++)a=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30,this.mt[this.mti]=(1812433253*((a&4294901760)>>>16)<<16)+1812433253*(a&65535)+this.mti,this.mt[this.mti]>>>=0};f.prototype.init_by_array=function(a,c){var b=1,e=0,g;this.init_genrand(19650218);for(g=this.N>c?this.N:c;g;g--){var f=this.mt[b-1]^this.mt[b-1]>>>
30;this.mt[b]=(this.mt[b]^(1664525*((f&4294901760)>>>16)<<16)+1664525*(f&65535))+a[e]+e;this.mt[b]>>>=0;b++;e++;b>=this.N&&(this.mt[0]=this.mt[this.N-1],b=1);e>=c&&(e=0)}for(g=this.N-1;g;g--)f=this.mt[b-1]^this.mt[b-1]>>>30,this.mt[b]=(this.mt[b]^(1566083941*((f&4294901760)>>>16)<<16)+1566083941*(f&65535))-b,this.mt[b]>>>=0,b++,b>=this.N&&(this.mt[0]=this.mt[this.N-1],b=1);this.mt[0]=2147483648};f.prototype.genrand_int32=function(){var a=[0,this.MATRIX_A];if(this.mti>=this.N){var b;this.mti===this.N+
1&&this.init_genrand(5489);for(b=0;b<this.N-this.M;b++){var d=this.mt[b]&this.UPPER_MASK|this.mt[b+1]&this.LOWER_MASK;this.mt[b]=this.mt[b+this.M]^d>>>1^a[d&1]}for(;b<this.N-1;b++)d=this.mt[b]&this.UPPER_MASK|this.mt[b+1]&this.LOWER_MASK,this.mt[b]=this.mt[b+(this.M-this.N)]^d>>>1^a[d&1];d=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK;this.mt[this.N-1]=this.mt[this.M-1]^d>>>1^a[d&1];this.mti=0}d=this.mt[this.mti++];d^=d>>>11;d^=d<<7&2636928640;d^=d<<15&4022730752;return(d^d>>>18)>>>
0};f.prototype.genrand_int31=function(){return this.genrand_int32()>>>1};f.prototype.genrand_real1=function(){return this.genrand_int32()*(1/4294967295)};f.prototype.random=function(){return this.genrand_int32()*(1/4294967296)};f.prototype.genrand_real3=function(){return(this.genrand_int32()+.5)*(1/4294967296)};f.prototype.genrand_res53=function(){var a=this.genrand_int32()>>>5,b=this.genrand_int32()>>>6;return 1.1102230246251565E-16*(67108864*a+b)};"undefined"!==typeof exports&&("undefined"!==typeof module&&
module.exports&&(exports=module.exports=b),exports.Chance=b);"function"===typeof define&&define.amd&&define("Chance",[],function(){return b});"object"===typeof k&&"object"===typeof k.document&&(k.Chance=b,k.chance=new b)})()});