AJS.test.require([
    "com.atlassian.plugin.jslibs:marionette-4.1.2-factory",
    "com.atlassian.plugin.jslibs:backbone-1.3.3-factory",
    "com.atlassian.plugin.jslibs:backbone.radio-2.0.0-factory",
    "com.atlassian.plugin.jslibs:underscore-1.8.3"
], function () {
    "use strict";

    require([
        "atlassian/libs/factories/marionette-4.1.2",
        "atlassian/libs/factories/backbone-1.3.3",
        "atlassian/libs/factories/backbone.radio-2.0.0",
        "atlassian/libs/underscore-1.8.3",
        "jquery"
    ], function (
        MarionetteFactory,
        BackboneFactory,
        BackboneRadioFactory,
        _,
        $
    ) {
        var Backbone = BackboneFactory(_, $);
        var BackboneRadio = BackboneRadioFactory(_, Backbone);

        module("atlassian/libs/factories/marionette-4.1.2", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
            },
            teardown: function() {
                this.sandbox.restore();
            }
        });

        test("It returns a function", function () {
            ok(typeof MarionetteFactory == "function");
        });

        test("It returns a copy of Marionette 4.1.2", function () {
            var Marionette = MarionetteFactory(_, Backbone, BackboneRadio);

            ok(Marionette.VERSION == "4.1.2");
        });

        test("Each call returns a new copy", function () {
            var Marionette1 = MarionetteFactory(_, Backbone, BackboneRadio);
            var Marionette2 = MarionetteFactory(_, Backbone, BackboneRadio);

            ok(Marionette1 !== Marionette2);
        });

        test("It uses the provided Backbone", function () {
            /* older versions spy on Router extend, but Marionette 4.x doesn't come with a router,
             AppRouter is now external module. Hence we test on View extend*/
            this.spy(Backbone.View, "extend");
            var Marionette = MarionetteFactory(_, Backbone, BackboneRadio);

            sinon.assert.called(Backbone.View.extend);
        });

        test("It uses the provided Backbone.Radio", function () {
            this.spy(BackboneRadio, "channel");
            var Marionette = MarionetteFactory(_, Backbone, BackboneRadio);

            var obj = new Marionette.MnObject({ channelName: "my-channel" });
            sinon.assert.calledOnce(BackboneRadio.channel);
        });

        test("It uses the provided Underscore", function () {
            var Marionette = MarionetteFactory(_, Backbone, BackboneRadio);
            this.spy(_, "result");

            var obj = new Marionette.MnObject();
            sinon.assert.called(_.result);
        });

        test("It does not pollute Backbone namespace", function () {
            MarionetteFactory(_, Backbone, BackboneRadio);

            equal(typeof Backbone.Marionette, "undefined");
            equal(typeof Backbone.ChildViewContainer, "undefined");
            equal(typeof Backbone.Wreqr, "undefined");
        });
    });
});
