AJS.test.require([
    "com.atlassian.plugin.jslibs:backbone-1.0.0-factory",
    "com.atlassian.plugin.jslibs:underscore-1.5.2"
], function () {
    "use strict";

    require([
        "atlassian/libs/factories/backbone-1.0.0",
        "atlassian/libs/underscore-1.5.2",
        "jquery"
    ], function (
        BackboneFactory,
        _,
        $
    ) {
        module("atlassian/libs/factories/backbone-1.0.0");

        test("It returns a function", function () {
            equal(typeof BackboneFactory, "function");
        });

        test("It returns a copy of Backbone 1.0.0", function () {
            var Backbone = BackboneFactory(_, $);
            equal(typeof Backbone, "object");
            equal(Backbone.VERSION, "1.0.0");
        });

        test("Each call returns a new copy", function () {
            var Backbone1 = BackboneFactory(_, $);
            var Backbone2 = BackboneFactory(_, $);

            notEqual(Backbone1, Backbone2);
        });

        test("It uses the provided Underscore", function () {
            this.spy(_, "extend");
            BackboneFactory(_, $);

            // Backbone uses _.extend() to construct itself
            sinon.assert.called(_.extend);
        });

        test("It uses the provided jQuery", function () {
            var Backbone = BackboneFactory(_, $);

            // Backbone exposes jQuery in Backbone.$
            strictEqual(Backbone.$, $);
        });
    });
});
