/*!
 * jQuery serializeObject - v0.2 - 1/20/2010
 * http://benalman.com/projects/jquery-misc-plugins/
 *
 * Copyright (c) 2010 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */

// Whereas .serializeArray() serializes a form into an array, .serializeObject()
// serializes a form into an (arguably more useful) object.

/////////// Modified by Atlassian ///////////
(function(factory) {
    define('atlassian/jquery-plugins/jquery.serializeobject-0.2', function () {
        return function(jQuery) {
            factory(window, document, jQuery);
            return jQuery;
        }
    });
})(function(window, document, jQuery){
/////// End of Atlassian modification ///////

(function($,undefined){
  '$:nomunge'; // Used by YUI compressor.

  $.fn.serializeObject = function(){
    var obj = {};

    $.each( this.serializeArray(), function(i,o){
      var n = o.name,
        v = o.value;

        obj[n] = obj[n] === undefined ? v
          : $.isArray( obj[n] ) ? obj[n].concat( v )
          : [ obj[n], v ];
    });

    return obj;
  };

})(jQuery);

/////////// Modified by Atlassian ///////////
});
/////// End of Atlassian modification ///////