AJS.test.require([
    "com.atlassian.plugin.jslibs:raphael-2.1.0-factory",
    "com.atlassian.plugin.jslibs:eve-0.2.4"
], function () {
    "use strict";

    require([
        "atlassian/libs/factories/raphael-2.1.0",
        "atlassian/libs/eve-0.2.4"
    ], function (
        RaphaelFactory,
        eve
    ) {
        module("atlassian/libs/factories/raphael-2.1.0");

        test("It returns a function", function () {
            ok(typeof RaphaelFactory == "function");
        });

        test("It returns a copy of Raphael 2.1.0", function () {
            var Raphael = RaphaelFactory(eve);
            ok(typeof Raphael == "function");
            ok(Raphael.version == "2.1.0");
        });

        test("Each call returns a new copy", function () {
            var Raphael1 = RaphaelFactory(eve);
            var Raphael2 = RaphaelFactory(eve);

            ok(Raphael1 !== Raphael2);
        });

        test("It uses the provided Eve", function () {
            this.spy(eve, "on");
            var Raphael = RaphaelFactory(eve);

            // Raphael uses eve.on() in the construct process
            sinon.assert.called(eve.on);
        });
    });
});
