AJS.test.require([
    "com.atlassian.plugin.jslibs:marionette-1.4.1-factory",
    "com.atlassian.plugin.jslibs:backbone-1.0.0-factory",
    "com.atlassian.plugin.jslibs:underscore-1.5.2"
], function () {
    "use strict";

    require([
        "atlassian/libs/factories/marionette-1.4.1",
        "atlassian/libs/factories/backbone-1.0.0",
        "atlassian/libs/underscore-1.5.2",
        "jquery"
    ], function (
        MarionetteFactory,
        BackboneFactory,
        _,
        $
    ) {
        var Backbone = BackboneFactory(_, $);

        module("atlassian/libs/factories/marionette-1.4.1", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
            },
            teardown: function() {
                this.sandbox.restore();
            }
        });

        test("It returns a function", function () {
            ok(typeof MarionetteFactory == "function");
        });

        test("It returns a copy of Marionette 1.4.1", function () {
            var Marionette = MarionetteFactory(_, Backbone);

            ok(Marionette.VERSION == "1.4.1");
        });

        test("Each call returns a new copy", function () {
            var Marionette1 = MarionetteFactory(_, Backbone);
            var Marionette2 = MarionetteFactory(_, Backbone);

            ok(Marionette1 !== Marionette2);
        });

        test("It uses the provided Backbone", function () {
            this.spy(Backbone.Router, "extend");
            var Marionette = MarionetteFactory(_, Backbone);

            sinon.assert.calledOnce(Backbone.Router.extend);
        });

        test("It uses the provided Underscore", function () {
            var Marionette = MarionetteFactory(_, Backbone);
            this.spy(_, "isFunction");

            var obj = new Marionette.Controller();
            sinon.assert.calledOnce(_.isFunction);
        });

        test("It exposes the internal Wreqr implementation", function () {
            var Marionette = MarionetteFactory(_, Backbone);

            equal(typeof Marionette.Wreqr, "object");
            equal(typeof Marionette.Wreqr.Handlers, "function");
        });

        test("It exposes the internal ChildViewContainer implementation", function () {
            var Marionette = MarionetteFactory(_, Backbone);

            equal(typeof Marionette.ChildViewContainer, "function");
        });

        test("It does not pollute Backbone namespace", function () {
            var Marionette = MarionetteFactory(_, Backbone);

            ok(typeof Backbone.ChildViewContainer === "undefined");
            ok(typeof Backbone.Wreqr === "undefined");
        });

        test("It does not pollute global namespace", function () {
            var Marionette = MarionetteFactory(_, Backbone);

            ok(typeof window.BackboneChildViewContainer === "undefined");
            ok(typeof window.BackboneWreqr === "undefined");
        });
    });
});
