AJS.test.require([
    "com.atlassian.plugin.jslibs:backbone.radio-2.0.0-factory",
    "com.atlassian.plugin.jslibs:backbone-1.3.3-factory",
    "com.atlassian.plugin.jslibs:underscore-1.8.3"
], function () {
    "use strict";

    require([
        "atlassian/libs/factories/backbone.radio-2.0.0",
        "atlassian/libs/factories/backbone-1.3.3",
        "atlassian/libs/underscore-1.8.3",
        "jquery"
    ], function (
        BackboneRadioFactory,
        BackboneFactory,
        _,
        $
    ) {
        var Backbone = BackboneFactory(_, $);

        module("atlassian/libs/factories/backbone.radio-2.0.0", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
            },
            teardown: function() {
                this.sandbox.restore();
            }
        });

        test("It returns a function", function () {
            ok(typeof BackboneRadioFactory == "function");
        });

        test("It returns a copy of Backbone.Paginator 2.0.0", function () {
            var BackboneRadio = BackboneRadioFactory(_, Backbone);

            ok(BackboneRadio.VERSION == "2.0.0");
        });

        test("Each call returns a new copy", function () {
            var BackboneRadio1 = BackboneRadioFactory(_, Backbone);
            var BackboneRadio2 = BackboneRadioFactory(_, Backbone);

            ok(BackboneRadio1 !== BackboneRadio2);
        });

        test("Allows creating Radio channels", function () {
            var BackboneRadio = BackboneRadioFactory(_, Backbone);
            var myChannel = BackboneRadio.channel("my-channel");

            ok(myChannel instanceof BackboneRadio.Channel);
        });

        test("It uses the provided Backbone", function () {
            this.spy(Backbone.Events, "on");
            var handler = sinon.spy();
            var BackboneRadio = BackboneRadioFactory(_, Backbone);
            var myChannel = BackboneRadio.channel("my-channel");
            myChannel.on("my-event", handler);

            sinon.assert.calledOnce(Backbone.Events.on);
            sinon.assert.calledWith(Backbone.Events.on, "my-event", handler);
        });

        test("It uses the provided Underscore", function () {
            this.spy(_, "extend");
            var BackboneRadio = BackboneRadioFactory(_, Backbone);

            sinon.assert.called(_.extend);
            sinon.assert.calledWith(_.extend, BackboneRadio);
        });

        test("It does not pollute the Backbone namespace", function () {
            var BackboneRadio = BackboneRadioFactory(_, Backbone);

            equal(typeof Backbone.Radio, "undefined");
        });
    });
});
