package com.atlassian.plugin.spring.scanner.extension.gemini;

import com.atlassian.plugin.spring.scanner.extension.OsgiBundleContextAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.gemini.blueprint.context.ConfigurableOsgiBundleApplicationContext;
import org.osgi.framework.BundleContext;
import org.springframework.core.io.ResourceLoader;

/**
 * Extracts bundle context from gemini classes (as created by NonValidatingOsgiApplicationContextCreator in Plugins 4.0+).
 */
public class GeminiOsgiBundleContextAccessor implements OsgiBundleContextAccessor {
    private static final Log log = LogFactory.getLog(GeminiOsgiBundleContextAccessor.class);

    @Override
    public BundleContext getBundleContext(ResourceLoader resourceLoader) {
        // gemini package (Plugins 4.0+)
        if (!(resourceLoader instanceof ConfigurableOsgiBundleApplicationContext)) {
            log.warn("Could not access BundleContext from ResourceLoader: expected resourceLoader to be an instance of "
                    + ConfigurableOsgiBundleApplicationContext.class.getName() + ": got "
                    + resourceLoader.getClass().getName());
            return null;
        }

        return ((ConfigurableOsgiBundleApplicationContext) resourceLoader).getBundleContext();
    }
}
