/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.maven;

import com.atlassian.plugin.spring.scanner.core.AtlassianSpringByteCodeScanner;
import com.atlassian.plugin.spring.scanner.core.ByteCodeScannerConfiguration;
import com.atlassian.plugin.spring.scanner.maven.MavenLogAdapter;
import com.atlassian.plugin.spring.scanner.maven.ScannedDependencyArtifactBuilder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.Utils;
import org.slf4j.Logger;

@Mojo(name="atlassian-spring-scanner", threadSafe=true, defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AtlassianSpringScannerMojo
extends AbstractMojo {
    private static final String OUR_NAME = "Atlassian Spring Byte Code Scanner";
    private static final String DEFAULT_INCLUDE_EXCLUDE = "-java\\..*, -javax\\..*, -sun\\..*, -com\\.sun\\..*";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="-java\\..*, -javax\\..*, -sun\\..*, -com\\.sun\\..*")
    private String includeExclude;
    @Parameter(defaultValue="false")
    private Boolean parallel;
    @Parameter(defaultValue="false")
    private Boolean verbose;
    @Parameter(defaultValue="false")
    private Boolean permitDuplicateImports;
    @Parameter
    private List<Dependency> scannedDependencies = new ArrayList<Dependency>();
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Starting Atlassian Spring Byte Code Scanner...");
        this.getLog().info((CharSequence)"");
        long then = System.currentTimeMillis();
        String outputDirectory = this.resolveOutputDirectory();
        if (!new File(outputDirectory).exists()) {
            this.getLog().warn((CharSequence)String.format("Skipping because %s was not found", outputDirectory));
            return;
        }
        this.warnInvalidScannedDependencies();
        ByteCodeScannerConfiguration.Builder config = ByteCodeScannerConfiguration.builder().setOutputDirectory(outputDirectory).setClassPathUrls(this.parseUrls()).setIncludeExclude(this.includeExclude).setLog(this.makeLogger()).setVerbose(this.verbose).setPermitDuplicateImports(this.permitDuplicateImports);
        AtlassianSpringByteCodeScanner scanner = AtlassianSpringByteCodeScanner.getInstance(config.build());
        AtlassianSpringByteCodeScanner.ScanResults scanResults = scanner.scan();
        long duration = System.currentTimeMillis() - then;
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)String.format("\tAnalysis ran in %d ms.", duration));
        this.getLog().info((CharSequence)String.format("\tEncountered %d total classes", scanResults.getClassesEncountered()));
        this.getLog().info((CharSequence)String.format("\tProcessed %d annotated classes", scanResults.getComponentClassesEncountered()));
        List<String> errors = scanResults.getErrors();
        if (!errors.isEmpty()) {
            String error = String.format("\t %d errors encountered during class analysis: %n\t %s", errors.size(), String.join((CharSequence)"\n\t", errors));
            this.getLog().error((CharSequence)error);
            throw new IllegalStateException(error);
        }
    }

    private Logger makeLogger() {
        return new MavenLogAdapter(this.getLog());
    }

    private Collection<URL> parseUrls() throws MojoExecutionException {
        HashSet<URI> uris = new HashSet<URI>();
        URI outputDirUrl = this.parseOutputDirUrl();
        uris.add(outputDirUrl);
        uris.addAll(this.getIncludedPackages());
        List<Artifact> projectArtifacts = this.getProjectArtifacts();
        List<Artifact> scannedArtifacts = AtlassianSpringScannerMojo.resolveArtifacts(this.getScannedArtifacts(), projectArtifacts);
        Iterable ignoredArtifacts = projectArtifacts.stream().filter(artifact -> scannedArtifacts.stream().noneMatch(scannedArtifact -> AtlassianSpringScannerMojo.sameGAV(scannedArtifact, artifact))).collect(Collectors.toList());
        Collection<URI> dependencyJars = this.getDependencyJars(scannedArtifacts);
        for (Artifact artifact2 : ignoredArtifacts) {
            this.logVerbose(String.format("\t(X) Ignoring dependency for scanning %s:%s:%s", artifact2.getGroupId(), artifact2.getArtifactId(), artifact2.getScope()));
        }
        uris.addAll(dependencyJars);
        this.getLog().info((CharSequence)"\t(/) The following directory will be scanned for annotations:");
        this.getLog().info((CharSequence)String.format("\t\t%s", outputDirUrl));
        if (!dependencyJars.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"\t(/) The following dependencies will also be scanned for annotations: ");
            this.getLog().info((CharSequence)"");
            for (URI jar : dependencyJars) {
                this.getLog().info((CharSequence)String.format("\t\t%s", jar));
            }
        }
        return AtlassianSpringScannerMojo.toUrls(uris);
    }

    private static Collection<URL> toUrls(Collection<URI> uris) throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URI uri : uris) {
            try {
                urls.add(uri.toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid URI " + String.valueOf(uri), (Exception)e);
            }
        }
        return urls;
    }

    private Collection<URI> getIncludedPackages() throws MojoExecutionException {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (!Utils.isEmpty((String)this.includeExclude)) {
            for (String string : this.includeExclude.split(",")) {
                String trimmed = string.trim();
                char prefix = trimmed.charAt(0);
                if (prefix != '+') continue;
                String pattern = trimmed.substring(1);
                this.logVerbose(String.format("\tAdding include / exclude %s", Character.valueOf(prefix)));
                for (URL url : ClasspathHelper.forPackage((String)pattern, (ClassLoader[])new ClassLoader[0])) {
                    uris.add(AtlassianSpringScannerMojo.toUri(url));
                }
            }
        }
        return uris;
    }

    private static URI toUri(URL url) throws MojoExecutionException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Invalid URL " + String.valueOf(url), (Exception)e);
        }
    }

    private Collection<URI> getDependencyJars(Collection<Artifact> scannedArtifacts) {
        scannedArtifacts.forEach(artifact -> this.logVerbose(String.format("\t(/) Including dependency for scanning %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getScope())));
        return scannedArtifacts.stream().map(Artifact::getFile).map(File::toURI).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void logVerbose(String message) {
        if (Boolean.TRUE.equals(this.verbose)) {
            this.getLog().info((CharSequence)message);
        }
    }

    private static boolean isSensibleScope(Artifact artifact) {
        return !"test".equals(artifact.getScope());
    }

    private URI parseOutputDirUrl() {
        return new File(this.resolveOutputDirectory() + "/").toURI();
    }

    private String resolveOutputDirectory() {
        return this.getProject().getBuild().getOutputDirectory();
    }

    private MavenProject getProject() {
        return this.project;
    }

    private static boolean sameGAV(Artifact artifact1, Artifact artifact2) {
        return artifact1.getGroupId().equals(artifact2.getGroupId()) && artifact1.getArtifactId().equals(artifact2.getArtifactId()) && artifact1.getVersion().equals(artifact2.getVersion());
    }

    private static List<Artifact> resolveArtifacts(Collection<Artifact> scannedArtifacts, Collection<Artifact> projectArtifacts) {
        return scannedArtifacts.stream().map(artifact -> projectArtifacts.stream().filter(projectArtifact -> AtlassianSpringScannerMojo.sameGAV(projectArtifact, artifact)).findFirst().orElseThrow(() -> new RuntimeException("Unable to find " + String.valueOf(artifact)))).collect(Collectors.toList());
    }

    private DependencyNode getDependencyGraph(MavenProject project) {
        try {
            return this.dependencyGraphBuilder.buildDependencyGraph(project, AtlassianSpringScannerMojo::isSensibleScope);
        }
        catch (DependencyGraphBuilderException e) {
            throw new IllegalStateException(e);
        }
    }

    private List<Artifact> getProjectArtifacts() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(this.project.getArtifacts());
        Collections.sort(artifacts);
        return artifacts;
    }

    private List<Artifact> getScannedArtifacts() {
        DependencyNode dependencyGraph = this.getDependencyGraph(this.project);
        return ScannedDependencyArtifactBuilder.buildScannedArtifacts(dependencyGraph, this.scannedDependencies);
    }

    private void warnInvalidScannedDependencies() {
        this.scannedDependencies.stream().map(Dependency::getArtifactId).filter(AtlassianSpringScannerMojo::isPartialWildcard).forEach(artifactId -> this.getLog().warn((CharSequence)String.format("Invalid artifact ID %s in scannedDependencies. Partial wildcards are not supported.", artifactId)));
    }

    private static boolean isPartialWildcard(String artifactId) {
        return artifactId.contains("*") && !"*".equals(artifactId);
    }
}

