/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core;

import com.atlassian.plugin.spring.scanner.annotation.export.ModuleType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.core.AnnotationValidator;
import com.atlassian.plugin.spring.scanner.core.JavassistHelper;
import com.atlassian.plugin.spring.scanner.core.ProfileFinder;
import com.atlassian.plugin.spring.scanner.core.SpringIndexWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import org.reflections.Store;
import org.reflections.scanners.AbstractScanner;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

class ClassScanner
extends AbstractScanner {
    private final boolean verbose;
    private final AnnotationValidator annotationValidator;
    private final JavassistHelper javassistHelper;
    private final List<String> errors = new ArrayList<String>();
    private final Logger log;
    private final ProfileFinder profileFinder;
    private final SpringIndexWriter springIndexWriter;
    private int classesEncountered;
    private int componentClassesEncountered;

    ClassScanner(AnnotationValidator annotationValidator, JavassistHelper javassistHelper, Logger log, ProfileFinder profileFinder, SpringIndexWriter springIndexWriter, boolean verbose) {
        this.annotationValidator = Objects.requireNonNull(annotationValidator);
        this.javassistHelper = Objects.requireNonNull(javassistHelper);
        this.log = Objects.requireNonNull(log);
        this.profileFinder = Objects.requireNonNull(profileFinder);
        this.springIndexWriter = Objects.requireNonNull(springIndexWriter);
        this.verbose = verbose;
    }

    public void scan(Object classObject, Store store) {
        ClassFile classFile = (ClassFile)classObject;
        try {
            this.scanClass(classFile);
        }
        catch (RuntimeException e) {
            this.log.error("Unable to run byte code scanner on class {}. Continuing to the next class...", (Object)classFile);
        }
    }

    private void scanClass(ClassFile classFile) {
        ++this.classesEncountered;
        Set<String> profiles = this.profileFinder.getProfiles(classFile);
        List classAnnotations = this.getMetadataAdapter().getClassAnnotationNames((Object)classFile);
        for (String annotation : classAnnotations) {
            if (!this.isInteresting(annotation)) continue;
            String className = this.getMetadataAdapter().getClassName((Object)classFile);
            if (!this.isInstantiableClass(classFile)) {
                this.log("\t\t(X) Class not suitable '%s' for annotation '%s'", className, annotation);
                return;
            }
            this.encounteredComponentClass(classFile, profiles, annotation, className);
        }
        this.scanConstructors(classFile, profiles);
        this.scanFields(classFile, profiles);
    }

    private void encounteredComponentClass(ClassFile classFile, Set<String> profiles, String annotation, String className) {
        ++this.componentClassesEncountered;
        String nameFromAnnotation = this.javassistHelper.getAnnotationMember(classFile, annotation);
        this.log("\t(/) Found annotation '%s' inside class '%s' with name '%s'", annotation, className, nameFromAnnotation);
        this.springIndexWriter.encounteredAnnotation(profiles, annotation, nameFromAnnotation, className);
        this.annotationValidator.encounteredAnnotation(annotation, className, className);
        if (ModuleType.class.getCanonicalName().equals(annotation)) {
            this.springIndexWriter.encounteredAnnotation(profiles, Component.class.getCanonicalName(), "", "com.atlassian.plugin.osgi.bridge.external.SpringHostContainer");
        }
    }

    private void log(String messageFormat, Object ... args) {
        if (this.log.isDebugEnabled() || this.verbose) {
            this.log.info(String.format(messageFormat, args));
        }
    }

    private boolean isInstantiableClass(ClassFile classFile) {
        String className = classFile.getName();
        if (classFile.isInterface()) {
            this.log.error("Found a type [{}] annotated as a component, but the type is not a concrete class. NOT adding to index file!!", (Object)className);
            return false;
        }
        if (classFile.isAbstract()) {
            this.log.error("Found a type [{}] annotated as a component, but the type is abstract. NOT adding to index file!!", (Object)className);
            return false;
        }
        return !this.profileFinder.isPackageClass(classFile);
    }

    private boolean isInteresting(String annotationType) {
        return super.acceptResult(annotationType) && this.springIndexWriter.isInteresting(annotationType);
    }

    private void scanConstructors(ClassFile classFile, Set<String> profiles) {
        String className = classFile.getName();
        List methods = classFile.getMethods();
        methods.stream().filter(MethodInfo::isConstructor).forEach(constructor -> this.scanConstructor(profiles, className, (MethodInfo)constructor));
    }

    private void scanConstructor(Set<String> profiles, String className, MethodInfo method) {
        List parameterTypes = this.getMetadataAdapter().getParameterNames((Object)method);
        for (int i = 0; i < parameterTypes.size(); ++i) {
            String parameterType = (String)parameterTypes.get(i);
            for (Annotation parameterAnnotation : this.javassistHelper.getParameterAnnotations(method, i)) {
                this.scanConstructorParameterAnnotation(profiles, className, parameterType, parameterAnnotation);
            }
        }
    }

    private void scanConstructorParameterAnnotation(Set<String> profiles, String className, String parameterType, Annotation annotation) {
        String annotationType = annotation.getTypeName();
        if (this.acceptResult(annotationType) && this.springIndexWriter.isParameterAnnotation(annotationType)) {
            String nameFromAnnotation = this.javassistHelper.getAnnotationMember(annotation);
            this.log("\t(/) Found '%s' inside class '%s' method '<init>' parameter '%s'", annotationType, className, parameterType);
            this.springIndexWriter.encounteredAnnotation(profiles, annotationType, nameFromAnnotation, parameterType);
            this.annotationValidator.encounteredAnnotation(annotationType, parameterType, className);
        }
    }

    private void scanFields(ClassFile classFile, Set<String> profiles) {
        List fields = classFile.getFields();
        fields.forEach(field -> this.scanField(classFile, profiles, (FieldInfo)field));
    }

    private void scanField(ClassFile classFile, Set<String> profiles, FieldInfo field) {
        LinkedList<String> annotationTypes = new LinkedList<String>();
        String fieldName = field.getName();
        AnnotationsAttribute annotations = (AnnotationsAttribute)field.getAttribute("RuntimeVisibleAnnotations");
        if (annotations != null) {
            for (Annotation annotation : annotations.getAnnotations()) {
                String annotationType = annotation.getTypeName();
                annotationTypes.add(annotationType);
                if (!this.acceptResult(annotationType) || !this.springIndexWriter.isFieldAnnotation(annotationType)) continue;
                String fieldType = Descriptor.toClassName((String)field.getDescriptor());
                String nameFromAnnotation = this.javassistHelper.getAnnotationMember(annotation);
                this.log("\t(/) Found '%s' inside class '%s' on field '%s' of type '%s'", annotationType, classFile.getName(), fieldName, fieldType);
                this.springIndexWriter.encounteredAnnotation(profiles, annotationType, nameFromAnnotation, fieldType);
                this.annotationValidator.encounteredAnnotation(annotationType, fieldType, classFile.getName());
            }
            if (annotationTypes.contains(ComponentImport.class.getCanonicalName())) {
                ArrayList<String> productImportsPresentOnField = new ArrayList<String>(SpringIndexWriter.KNOWN_PRODUCT_IMPORT_ANNOTATIONS);
                productImportsPresentOnField.retainAll(annotationTypes);
                if (!productImportsPresentOnField.isEmpty()) {
                    this.errors.add(String.format("ComponentImport annotation cannot be used with product specific component imports: %s found on %s.%s", Arrays.toString(productImportsPresentOnField.toArray()), classFile.getName(), fieldName));
                }
            }
        }
    }

    public int getClassesEncountered() {
        return this.classesEncountered;
    }

    public int getComponentClassesEncountered() {
        return this.componentClassesEncountered;
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }
}

