/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core;

import com.atlassian.plugin.spring.scanner.annotation.Profile;
import com.atlassian.plugin.spring.scanner.core.JavassistHelper;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javassist.bytecode.ClassFile;
import org.slf4j.Logger;

class ProfileFinder {
    private static final String PACKAGE_INFO = "package-info";
    private final Set<URL> buildPath;
    private final Logger log;
    private final JavassistHelper javassistHelper;
    private final Map<String, Set<String>> mapOfPackagesToProfiles = new TreeMap<String, Set<String>>();

    public ProfileFinder(Set<URL> buildPath, Logger log) {
        this.buildPath = buildPath;
        this.log = log;
        this.javassistHelper = new JavassistHelper();
    }

    boolean isPackageClass(ClassFile classFile) {
        return classFile.getName().endsWith(".package-info");
    }

    Set<String> getProfiles(ClassFile classFile) {
        String classFileName = classFile.getName();
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("Checking for profile annotations on %s", classFileName));
        }
        if (this.isPackageClass(classFile)) {
            this.recordPackageClassProfileAnnotations(classFile);
            return Collections.emptySet();
        }
        Set<String> packageInfoProfileAnnotations = this.getPackageInfoProfileAnnotations(classFile);
        Set<String> classSpecificProfiles = this.findProfiles(classFile);
        if (!classSpecificProfiles.isEmpty()) {
            return classSpecificProfiles;
        }
        return packageInfoProfileAnnotations;
    }

    private void recordPackageClassProfileAnnotations(ClassFile packageInfoClassFile) {
        String packageName = this.getClassPackageAsFileName(packageInfoClassFile);
        Set<String> profiles = this.mapOfPackagesToProfiles.get(packageName);
        if (profiles == null) {
            this.mapOfPackagesToProfiles.put(packageName, this.findProfiles(packageInfoClassFile));
        }
    }

    private Set<String> getPackageInfoProfileAnnotations(ClassFile classFile) {
        String packageName = this.getClassPackageAsFileName(classFile);
        Set<String> profiles = this.mapOfPackagesToProfiles.get(packageName);
        if (profiles != null) {
            return profiles;
        }
        ClassFile packageInfoClassFile = this.loadPackageInfoClass(packageName);
        if (packageInfoClassFile != null) {
            this.recordPackageClassProfileAnnotations(packageInfoClassFile);
        } else {
            this.mapOfPackagesToProfiles.put(packageName, Collections.emptySet());
        }
        return this.mapOfPackagesToProfiles.get(packageName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClassFile loadPackageInfoClass(String packageName) {
        Iterator<URL> iterator = this.buildPath.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            try {
                File parentFile = new File(url.toURI());
                File packageInfoFile = new File(parentFile, packageName + "/package-info.class");
                if (!packageInfoFile.exists()) continue;
                try (FileInputStream inputStream = new FileInputStream(packageInfoFile);){
                    DataInputStream dis = new DataInputStream(new BufferedInputStream(inputStream));
                    ClassFile classFile = new ClassFile(dis);
                    return classFile;
                }
                catch (IOException e) {
                    this.log.error(String.format("Could not create class file from %s", packageInfoFile), (Throwable)e);
                }
            }
            catch (URISyntaxException e) {
                this.log.error(String.format("Unable to load package-info file %s from %s", packageName, url));
            }
        }
        return null;
    }

    private Set<String> findProfiles(ClassFile classFile) {
        List<String> classAnnotationNames = this.javassistHelper.getClassAnnotationNames(classFile);
        TreeSet<String> profiles = new TreeSet<String>();
        for (String annotationType : classAnnotationNames) {
            Set<String> profileValues;
            if (Profile.class.getCanonicalName().equals(annotationType)) {
                profileValues = this.javassistHelper.getAnnotationMemberSet(classFile, annotationType, "value");
                profiles.addAll(profileValues);
            }
            if (!"org.springframework.context.annotation.Profile".equals(annotationType)) continue;
            profileValues = this.javassistHelper.getAnnotationMemberSet(classFile, annotationType, "value");
            profiles.addAll(profileValues);
        }
        return profiles;
    }

    private String getClassPackageAsFileName(ClassFile classFile) {
        String fileName = classFile.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot == -1) {
            return fileName;
        }
        String packageName = fileName.substring(0, lastDot);
        return packageName.replace('.', '/');
    }
}

