/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.maven;

import com.atlassian.plugin.spring.scanner.core.AtlassianSpringByteCodeScanner;
import com.atlassian.plugin.spring.scanner.core.ByteCodeScannerConfiguration;
import com.atlassian.plugin.spring.scanner.maven.MavenLogAdapter;
import com.atlassian.plugin.spring.scanner.maven.ScannedDependencyArtifactBuilder;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.Utils;
import org.slf4j.Logger;

@Mojo(name="atlassian-spring-scanner", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AtlassianSpringScannerMojo
extends AbstractMojo {
    private static final String OUR_NAME = "Atlassian Spring Byte Code Scanner";
    private static final String DEFAULT_INCLUDE_EXCLUDE = "-java\\..*, -javax\\..*, -sun\\..*, -com\\.sun\\..*";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="-java\\..*, -javax\\..*, -sun\\..*, -com\\.sun\\..*")
    private String includeExclude;
    @Parameter(defaultValue="false")
    private Boolean parallel;
    @Parameter(defaultValue="false")
    private Boolean verbose;
    @Parameter
    private List<Dependency> scannedDependencies = new ArrayList<Dependency>();
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Starting Atlassian Spring Byte Code Scanner...");
        this.getLog().info((CharSequence)"");
        long then = System.currentTimeMillis();
        String outputDirectory = this.resolveOutputDirectory();
        if (!new File(outputDirectory).exists()) {
            this.getLog().warn((CharSequence)String.format("Skipping because %s was not found", outputDirectory));
            return;
        }
        this.warnInvalidScannedDependencies();
        ByteCodeScannerConfiguration.Builder config = ByteCodeScannerConfiguration.builder().setOutputDirectory(outputDirectory).setClassPathUrls(this.parseUrls()).setIncludeExclude(this.includeExclude).setLog(this.makeLogger()).setVerbose(this.verbose);
        AtlassianSpringByteCodeScanner scanner = new AtlassianSpringByteCodeScanner(config.build());
        long ms = System.currentTimeMillis() - then;
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)String.format("\tAnalysis ran in %d ms.", ms));
        this.getLog().info((CharSequence)String.format("\tEncountered %d total classes", scanner.getStats().getClassesEncountered()));
        this.getLog().info((CharSequence)String.format("\tProcessed %d annotated classes", scanner.getStats().getComponentClassesEncountered()));
        if (!scanner.getErrors().getErrorsEncountered().isEmpty()) {
            String error = String.format("\t %d errors encountered during class analysis: \n\t %s", scanner.getErrors().getErrorsEncountered().size(), scanner.getErrors().getErrorsEncountered().stream().collect(Collectors.joining("\n\t")));
            this.getLog().error((CharSequence)error);
            throw new IllegalStateException(error);
        }
    }

    private Logger makeLogger() {
        return new MavenLogAdapter(this.getLog());
    }

    private Set<URL> parseUrls() throws MojoExecutionException {
        HashSet urls = Sets.newHashSet();
        URL outputDirUrl = this.parseOutputDirUrl();
        urls.add(outputDirUrl);
        if (!Utils.isEmpty((String)this.includeExclude)) {
            for (String string : this.includeExclude.split(",")) {
                String trimmed = string.trim();
                char prefix = trimmed.charAt(0);
                String pattern = trimmed.substring(1);
                if (prefix != '+') continue;
                this.logVerbose(String.format("\tAdding include / exclude %s", Character.valueOf(prefix)));
                urls.addAll(ClasspathHelper.forPackage((String)pattern, (ClassLoader[])new ClassLoader[0]));
            }
        }
        LinkedHashSet dependencyJars = Sets.newLinkedHashSet();
        List<Artifact> projectArtifacts = this.getProjectArtifacts();
        final Iterable<Artifact> scannedArtifacts = this.resolveArtifacts(this.getScannedArtifacts(), projectArtifacts);
        Iterable ignoredArtifacts = Iterables.filter(projectArtifacts, (Predicate)new Predicate<Artifact>(){

            public boolean apply(@Nullable Artifact input) {
                return !Iterables.any((Iterable)scannedArtifacts, (Predicate)AtlassianSpringScannerMojo.this.artifactMatchesGAV(input));
            }
        });
        for (Artifact artifact : scannedArtifacts) {
            this.logVerbose(String.format("\t(/) Including dependency for scanning %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getScope()));
            File file = artifact.getFile();
            try {
                URL url = file.toURI().toURL();
                dependencyJars.add(url);
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)String.format("Enable to create URL from plugin artifact : %s", file), (Throwable)e);
            }
        }
        for (Artifact artifact : ignoredArtifacts) {
            this.logVerbose(String.format("\t(X) Ignoring dependency for scanning %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getScope()));
        }
        urls.addAll(dependencyJars);
        this.getLog().info((CharSequence)"\t(/) The following directory will be scanned for annotations :");
        this.getLog().info((CharSequence)String.format("\t\t%s", outputDirUrl));
        if (dependencyJars.size() > 0) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"\t(/) The following dependencies will also be scanned for annotations : ");
            this.getLog().info((CharSequence)"");
            for (URL jar : dependencyJars) {
                this.getLog().info((CharSequence)String.format("\t\t%s", jar));
            }
        }
        return urls;
    }

    private void logVerbose(String message) {
        if (this.verbose.booleanValue()) {
            this.getLog().info((CharSequence)message);
        }
    }

    private boolean isSensibleScope(Artifact artifact) {
        return !"test".equals(artifact.getScope());
    }

    private URL parseOutputDirUrl() throws MojoExecutionException {
        try {
            File outputDirectoryFile = new File(this.resolveOutputDirectory() + '/');
            return outputDirectoryFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private String resolveOutputDirectory() {
        return this.getProject().getBuild().getOutputDirectory();
    }

    private MavenProject getProject() {
        return this.project;
    }

    private Predicate<Artifact> artifactMatchesGAV(final Artifact artifact) {
        return new Predicate<Artifact>(){

            public boolean apply(Artifact input) {
                return artifact.getGroupId().equals(input.getGroupId()) && artifact.getArtifactId().equals(input.getArtifactId()) && artifact.getVersion().equals(input.getVersion());
            }
        };
    }

    private Iterable<Artifact> resolveArtifacts(List<Artifact> scannedArtifacts, final Iterable<Artifact> projectArtifacts) {
        return Iterables.transform(scannedArtifacts, (Function)new Function<Artifact, Artifact>(){

            public Artifact apply(Artifact input) {
                try {
                    return (Artifact)Iterables.find((Iterable)projectArtifacts, (Predicate)AtlassianSpringScannerMojo.this.artifactMatchesGAV(input));
                }
                catch (NoSuchElementException e) {
                    throw new RuntimeException("Unable to find " + input, e);
                }
            }
        });
    }

    private DependencyNode getDependencyGraph(MavenProject project) {
        try {
            return this.dependencyGraphBuilder.buildDependencyGraph(project, new ArtifactFilter(){

                public boolean include(Artifact artifact) {
                    return AtlassianSpringScannerMojo.this.isSensibleScope(artifact);
                }
            });
        }
        catch (DependencyGraphBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Artifact> getProjectArtifacts() {
        ArrayList artifacts = Lists.newArrayList((Iterable)this.project.getArtifacts());
        Collections.sort(artifacts);
        return artifacts;
    }

    private List<Artifact> getScannedArtifacts() {
        DependencyNode dependencyGraph = this.getDependencyGraph(this.project);
        return ScannedDependencyArtifactBuilder.buildScannedArtifacts(dependencyGraph, this.scannedDependencies);
    }

    private void warnInvalidScannedDependencies() {
        for (Dependency dependency : this.scannedDependencies) {
            if (!dependency.getArtifactId().contains("*") || "*".equals(dependency.getArtifactId())) continue;
            this.getLog().warn((CharSequence)String.format("Invalid artifact ID %s in scannedDependencies. Partial wildcards are not currently supported.", dependency.getArtifactId()));
        }
    }
}

