/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core;

import com.atlassian.plugin.spring.scanner.ProductFilter;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ClasspathComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.FecruComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.RefappComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.StashComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsDevService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.export.ModuleType;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.FecruImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.RefappImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.StashImport;
import com.atlassian.plugin.spring.scanner.core.vfs.VirtualFile;
import com.atlassian.plugin.spring.scanner.core.vfs.VirtualFileFactory;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

public class SpringIndexWriter {
    public static final List<String> KNOWN_PRODUCT_IMPORT_ANNOTATIONS = ImmutableList.of((Object)BambooImport.class.getCanonicalName(), (Object)BitbucketImport.class.getCanonicalName(), (Object)ConfluenceImport.class.getCanonicalName(), (Object)FecruImport.class.getCanonicalName(), (Object)JiraImport.class.getCanonicalName(), (Object)RefappImport.class.getCanonicalName(), (Object)StashImport.class.getCanonicalName());
    private final Map<String, RecordedAnnotationsHolder> recordedProfiles = new HashMap<String, RecordedAnnotationsHolder>();
    private final VirtualFileFactory fileFactory;

    public SpringIndexWriter(String baseDir) {
        this.cleanDirectory(new File(baseDir, "META-INF/plugin-components"));
        this.fileFactory = baseDir != null ? new VirtualFileFactory(new File(baseDir)) : null;
    }

    public boolean isInteresting(@Nullable String annotationType) {
        return MeaningfulAnnotation.fromCanonicalName(annotationType).isPresent();
    }

    public boolean isParameterAnnotation(@Nullable String annotationType) {
        return MeaningfulAnnotation.fromCanonicalName(annotationType).map(a -> ((MeaningfulAnnotation)a).parameterAnnotation).orElse(false);
    }

    public boolean isFieldAnnotation(@Nullable String annotationType) {
        return MeaningfulAnnotation.fromCanonicalName(annotationType).map(a -> ((MeaningfulAnnotation)a).fieldAnnotation).orElse(false);
    }

    public void encounteredAnnotation(Set<String> targetProfiles, String annotationType, @Nullable String nameFromAnnotation, String componentClass) {
        HashSet<String> profiles = new HashSet<String>(targetProfiles);
        if (profiles.isEmpty()) {
            profiles.add("default");
        }
        for (String profile : profiles) {
            this.recordedProfiles.computeIfAbsent(profile, ignored -> new RecordedAnnotationsHolder()).recordAnnotation(annotationType, nameFromAnnotation, componentClass);
        }
    }

    public void writeIndexes() {
        for (Map.Entry<String, RecordedAnnotationsHolder> annotationsEntry : this.recordedProfiles.entrySet()) {
            this.writeProfileIndexes(annotationsEntry.getKey(), annotationsEntry.getValue());
        }
    }

    private void writeProfileIndexes(String profileName, RecordedAnnotationsHolder annotations) {
        Map<String, Set<String>> fileNameToComponents = this.collapse(annotations);
        for (Map.Entry<String, Set<String>> entry : fileNameToComponents.entrySet()) {
            try {
                this.writeIndexFile(profileName, entry.getKey(), entry.getValue());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private Map<String, Set<String>> collapse(RecordedAnnotationsHolder annotations) {
        HashMap<String, Set<String>> fileNameToComponents = new HashMap<String, Set<String>>();
        for (Map.Entry<MeaningfulAnnotation, Set<String>> entry : annotations.getRecordedAnnotations().entrySet()) {
            MeaningfulAnnotation meaningfulAnnotation = entry.getKey();
            if (!meaningfulAnnotation.isWrittenToDisk()) continue;
            Set<String> perAnnotationComponents = entry.getValue();
            String indexFileName = meaningfulAnnotation.getFileName();
            fileNameToComponents.computeIfAbsent(indexFileName, key -> new TreeSet()).addAll(perAnnotationComponents);
        }
        return fileNameToComponents;
    }

    private void writeIndexFile(String profileName, String indexFileName, Set<String> entries) throws IOException {
        if (this.fileFactory == null) {
            return;
        }
        File file = this.makeProfiledFileName(profileName, indexFileName);
        VirtualFile vf = this.fileFactory.getFile(file.getPath());
        TreeSet<String> lines = new TreeSet<String>();
        lines.addAll(vf.readLines());
        lines.addAll(entries);
        vf.writeLines(lines);
    }

    private File makeProfiledFileName(String profileName, String fileName) {
        File file = "default".equals(profileName) ? new File(fileName) : new File("profile-" + profileName, fileName);
        return new File("META-INF/plugin-components", file.getPath());
    }

    private void cleanDirectory(File destination) {
        if (destination.exists()) {
            try {
                Files.walkFileTree(destination.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                        if (e != null) {
                            throw e;
                        }
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to delete directory " + destination, e);
            }
        }
    }

    static class RecordedAnnotationsHolder {
        final Map<MeaningfulAnnotation, Set<String>> recordedAnnotations = new EnumMap<MeaningfulAnnotation, Set<String>>(MeaningfulAnnotation.class);

        RecordedAnnotationsHolder() {
        }

        @Nonnull
        public Map<MeaningfulAnnotation, Set<String>> getRecordedAnnotations() {
            return Collections.unmodifiableMap(this.recordedAnnotations);
        }

        public void recordAnnotation(String annotationType, @Nullable String nameFromAnnotation, String componentClass) {
            String trimmed;
            Optional annotation = MeaningfulAnnotation.fromCanonicalName(annotationType);
            if (!annotation.isPresent()) {
                throw new IllegalStateException("Annotation " + annotationType + " not found");
            }
            StringBuilder entry = new StringBuilder(componentClass);
            if (nameFromAnnotation != null && !(trimmed = nameFromAnnotation.trim()).isEmpty()) {
                entry.append("#").append(trimmed);
            }
            this.recordAnnotation((MeaningfulAnnotation)((Object)annotation.get()), entry.toString());
        }

        private void recordAnnotation(MeaningfulAnnotation meaningfulAnnotation, String value) {
            this.recordedAnnotations.computeIfAbsent(meaningfulAnnotation, key -> new TreeSet()).add(value);
        }
    }

    static enum MeaningfulAnnotation {
        COMPONENT("component", Component.class),
        SERVICE("component", Service.class),
        CONTROLLER("component", Controller.class),
        REPOSITORY("component", Repository.class),
        PRIMARY("primary-component", Primary.class),
        SINGLETON("component", Singleton.class, true, true),
        NAMED("component", Named.class, false, true),
        CLASSPATH_COMPONENT("component", ClasspathComponent.class, true, true),
        BAMBOO_COMPONENT(ProductFilter.BAMBOO.getPerProductFile("component"), BambooComponent.class, true, true),
        BITBUCKET_COMPONENT(ProductFilter.BITBUCKET.getPerProductFile("component"), BitbucketComponent.class, true, true),
        CONFLUENCE_COMPONENT(ProductFilter.CONFLUENCE.getPerProductFile("component"), ConfluenceComponent.class, true, true),
        JIRA_COMPONENT(ProductFilter.JIRA.getPerProductFile("component"), JiraComponent.class, true, true),
        FECRU_COMPONENT(ProductFilter.FECRU.getPerProductFile("component"), FecruComponent.class, true, true),
        REFAPP_COMPONENT(ProductFilter.REFAPP.getPerProductFile("component"), RefappComponent.class, true, true),
        STASH_COMPONENT(ProductFilter.STASH.getPerProductFile("component"), StashComponent.class, true, true),
        IMPORTS("imports", ComponentImport.class, true, true),
        BAMBOO_IMPORTS(ProductFilter.BAMBOO.getPerProductFile("imports"), BambooImport.class, true, true),
        BITBUCKET_IMPORTS(ProductFilter.BITBUCKET.getPerProductFile("imports"), BitbucketImport.class, true, true),
        CONFLUENCE_IMPORTS(ProductFilter.CONFLUENCE.getPerProductFile("imports"), ConfluenceImport.class, true, true),
        FECRU_IMPORTS(ProductFilter.FECRU.getPerProductFile("imports"), FecruImport.class, true, true),
        JIRA_IMPORTS(ProductFilter.JIRA.getPerProductFile("imports"), JiraImport.class, true, true),
        REFAPP_IMPORTS(ProductFilter.REFAPP.getPerProductFile("imports"), RefappImport.class, true, true),
        STASH_IMPORTS(ProductFilter.STASH.getPerProductFile("imports"), StashImport.class, true, true),
        EXPORT_AS_SERVICE("exports", ExportAsService.class, true, true),
        EXPORT_AS_DEV_SERVICE("dev-exports", ExportAsDevService.class, true, true),
        MODULE_TYPE("exports", ModuleType.class);

        private static final Map<String, MeaningfulAnnotation> CANONICAL_NAME_INDEX;
        private final String fileName;
        private final Class<?> forAnnotation;
        private final boolean parameterAnnotation;
        private final boolean fieldAnnotation;

        private MeaningfulAnnotation(String fileName, Class<?> forAnnotation) {
            this(fileName, forAnnotation, false, false);
        }

        private MeaningfulAnnotation(String fileName, Class<?> forAnnotation, boolean parameterAnnotation, boolean fieldAnnotation) {
            this.fileName = Objects.requireNonNull(fileName);
            this.forAnnotation = Objects.requireNonNull(forAnnotation);
            this.parameterAnnotation = parameterAnnotation;
            this.fieldAnnotation = fieldAnnotation;
        }

        @Nonnull
        private static Optional<MeaningfulAnnotation> fromCanonicalName(String annotationType) {
            return Optional.ofNullable(CANONICAL_NAME_INDEX.get(annotationType));
        }

        private String getFileName() {
            return this.fileName;
        }

        private boolean isWrittenToDisk() {
            return this.fileName != null;
        }

        static {
            CANONICAL_NAME_INDEX = new HashMap<String, MeaningfulAnnotation>();
            Arrays.stream(MeaningfulAnnotation.values()).forEach(meaningfulAnnotation -> CANONICAL_NAME_INDEX.put(meaningfulAnnotation.forAnnotation.getCanonicalName(), (MeaningfulAnnotation)((Object)meaningfulAnnotation)));
        }
    }
}

