package com.atlassian.plugin.spring.scanner;

/**
 * An enum representing the products that we can filter beans by.
 * This enum is used not only within this library, but may also be used by
 * any other library/plugin that needs a list of products to filter by.
 *
 * Example: Atlassian Connect uses this enum to filter out product-specific
 * connect modules. Moral of the story: Don't remove this.
 */
public enum ProductFilter {

    ALL, JIRA, CONFLUENCE, BAMBOO, BITBUCKET, CROWD, FECRU, REFAPP;

    /**
     * Indicates whether this enum contains the given product. Equivalent to calling {@link #valueOf(String)} and
     * seeing whether an {@link IllegalArgumentException} is thrown.
     *
     * @param productName the uppercase product name, or the literal String {@code ALL}
     * @return see description
     */
    public static boolean hasProduct(String productName) {
        try {
            valueOf(productName);
            return true;
        } catch (final IllegalArgumentException e) {
            return false;
        }
    }

    /**
     * Returns a qualified version of the given filename stem, generated by appending a product-specific suffix to it.
     *
     * @param fileStem the file stem to which to append the suffix
     * @return the complete file name
     */
    public String getPerProductFile(final String fileStem) {
        return fileStem + "-" + name().toLowerCase();
    }
}
