/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api.load;

import com.atlassian.performance.tools.jiraactions.api.action.Action;
import com.atlassian.performance.tools.jiraactions.api.measure.ActionMeter;
import com.atlassian.performance.tools.virtualusers.api.TemporalRate;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserTasks;
import com.atlassian.performance.tools.virtualusers.api.diagnostics.Diagnostics;
import com.atlassian.performance.tools.virtualusers.api.load.LoadThread;
import com.atlassian.performance.tools.virtualusers.collections.CircularIterator;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/load/ThrottlingActionLoop;", "Lcom/atlassian/performance/tools/virtualusers/api/load/LoadThread;", "maxLoad", "Lcom/atlassian/performance/tools/virtualusers/api/TemporalRate;", "taskMeter", "Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;", "actions", "", "Lcom/atlassian/performance/tools/jiraactions/api/action/Action;", "diagnostics", "Lcom/atlassian/performance/tools/virtualusers/api/diagnostics/Diagnostics;", "(Lcom/atlassian/performance/tools/virtualusers/api/TemporalRate;Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;Ljava/lang/Iterable;Lcom/atlassian/performance/tools/virtualusers/api/diagnostics/Diagnostics;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "generateLoad", "", "stop", "Ljava/util/concurrent/atomic/AtomicBoolean;", "runWithDiagnostics", "action", "runWithDiagnostics$virtual_users", "virtual-users"})
public final class ThrottlingActionLoop
implements LoadThread {
    private final Logger logger;
    private final TemporalRate maxLoad;
    private final ActionMeter taskMeter;
    private final Iterable<Action> actions;
    private final Diagnostics diagnostics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void generateLoad(@NotNull AtomicBoolean stop) {
        Iterator it2;
        void $receiver$iv$iv;
        Iterable<Action> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)stop, (String)"stop");
        this.logger.info("Applying load...");
        Iterable<Action> iterable = $receiver$iv = this.actions;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Action action = (Action)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it2.getClass().getSimpleName();
            collection.add(string);
        }
        List actionNames = (List)destination$iv$iv;
        this.logger.debug("Circling through " + actionNames);
        double actionsPerformed = 0.0;
        Instant start2 = Instant.now();
        Iterator iterator = it2 = (Iterator)new CircularIterator<Action>(this.actions);
        while (iterator.hasNext()) {
            Duration extraTime;
            Duration actualTimeSoFar;
            Duration expectedTimeSoFar;
            Action action = (Action)iterator.next();
            if (stop.get()) {
                this.logger.info("Done applying load");
                break;
            }
            try {
                this.runWithDiagnostics$virtual_users(action);
            }
            catch (Exception e2) {
                try {
                    this.logger.error("Failed to run " + action + ", but we keep running", (Throwable)e2);
                }
                catch (Throwable throwable) {
                    double actualTimeSoFar2 = actionsPerformed;
                    actionsPerformed = actualTimeSoFar2 + 1.0;
                    Duration expectedTimeSoFar2 = this.maxLoad.scaleChange(actionsPerformed).getTime();
                    Duration actualTimeSoFar3 = Duration.between(start2, Instant.now());
                    Duration extraTime2 = expectedTimeSoFar2.minus(actualTimeSoFar3);
                    if (extraTime2.compareTo(Duration.ZERO) > 0) {
                        this.taskMeter.measure(VirtualUserTasks.THROTTLING, (Function0)new Function0<Unit>(extraTime2){
                            final /* synthetic */ Duration $extraTime;

                            public final void invoke() {
                                Thread.sleep(this.$extraTime.toMillis());
                            }
                            {
                                this.$extraTime = duration;
                                super(0);
                            }
                        });
                    }
                    throw throwable;
                }
                double e2 = actionsPerformed;
                expectedTimeSoFar = this.maxLoad.scaleChange(actionsPerformed = e2 + 1.0).getTime();
                extraTime = expectedTimeSoFar.minus(actualTimeSoFar = Duration.between(start2, Instant.now()));
                if (extraTime.compareTo(Duration.ZERO) <= 0) continue;
                this.taskMeter.measure(VirtualUserTasks.THROTTLING, (Function0)new /* invalid duplicate definition of identical inner class */);
                continue;
            }
            double it2 = actionsPerformed;
            expectedTimeSoFar = this.maxLoad.scaleChange(actionsPerformed = it2 + 1.0).getTime();
            extraTime = expectedTimeSoFar.minus(actualTimeSoFar = Duration.between(start2, Instant.now()));
            if (extraTime.compareTo(Duration.ZERO) <= 0) continue;
            this.taskMeter.measure(VirtualUserTasks.THROTTLING, (Function0)new /* invalid duplicate definition of identical inner class */);
        }
    }

    public final void runWithDiagnostics$virtual_users(@NotNull Action action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        try {
            this.logger.trace("Running " + action + "...");
            this.taskMeter.measure(VirtualUserTasks.ACTING, (Function0)new Function0<Unit>(action){
                final /* synthetic */ Action $action;

                public final void invoke() {
                    this.$action.run();
                }
                {
                    this.$action = action;
                    super(0);
                }
            });
            this.logger.trace("Finished " + action);
        }
        catch (Exception e) {
            this.taskMeter.measure(VirtualUserTasks.DIAGNOSING, (Function0)new Function0<Unit>(this, e){
                final /* synthetic */ ThrottlingActionLoop this$0;
                final /* synthetic */ Exception $e;

                public final void invoke() {
                    ThrottlingActionLoop.access$getDiagnostics$p(this.this$0).diagnose(this.$e);
                }
                {
                    this.this$0 = throttlingActionLoop;
                    this.$e = exception;
                    super(0);
                }
            });
            throw (Throwable)new Exception("Failed to run " + action, e);
        }
    }

    public ThrottlingActionLoop(@NotNull TemporalRate maxLoad, @NotNull ActionMeter taskMeter, @NotNull Iterable<? extends Action> actions, @NotNull Diagnostics diagnostics) {
        Intrinsics.checkParameterIsNotNull((Object)maxLoad, (String)"maxLoad");
        Intrinsics.checkParameterIsNotNull((Object)taskMeter, (String)"taskMeter");
        Intrinsics.checkParameterIsNotNull(actions, (String)"actions");
        Intrinsics.checkParameterIsNotNull((Object)diagnostics, (String)"diagnostics");
        this.maxLoad = maxLoad;
        this.taskMeter = taskMeter;
        this.actions = actions;
        this.diagnostics = diagnostics;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    public static final /* synthetic */ Diagnostics access$getDiagnostics$p(ThrottlingActionLoop $this) {
        return $this.diagnostics;
    }
}

