/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api.diagnostics;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/diagnostics/DiagnosisPatience;", "", "patience", "Ljava/time/Duration;", "(Ljava/time/Duration;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "<set-?>", "", "lost", "getLost", "()Z", "test", "", "duration", "virtual-users"})
public final class DiagnosisPatience {
    private volatile boolean lost;
    private final Logger logger;
    private final Duration patience;

    public final boolean getLost() {
        return this.lost;
    }

    public final void test(@NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        if (duration.compareTo(this.patience) > 0) {
            this.lost = true;
            this.logger.info("Lost patience after waiting " + duration + " for diagnosis, no more diagnoses will be made");
        }
    }

    public DiagnosisPatience(@NotNull Duration patience) {
        Intrinsics.checkParameterIsNotNull((Object)patience, (String)"patience");
        this.patience = patience;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

