/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api.config;

import com.atlassian.performance.tools.jiraactions.api.SeededRandom;
import com.atlassian.performance.tools.jiraactions.api.measure.ActionMeter;
import com.atlassian.performance.tools.jiraactions.api.measure.output.ActionMetricOutput;
import com.atlassian.performance.tools.jiraactions.api.measure.output.AppendableActionMetricOutput;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserLoad;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserResult;
import com.atlassian.performance.tools.virtualusers.api.config.LoadProcessContainer;
import java.io.BufferedWriter;
import java.time.Duration;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0011J\u0006\u0010\u001c\u001a\u00020\u001dR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/config/LoadThreadContainer;", "Ljava/lang/AutoCloseable;", "processContainer", "Lcom/atlassian/performance/tools/virtualusers/api/config/LoadProcessContainer;", "index", "", "uuid", "Ljava/util/UUID;", "(Lcom/atlassian/performance/tools/virtualusers/api/config/LoadProcessContainer;ILjava/util/UUID;)V", "closeables", "Ljava/util/Queue;", "id", "", "getId", "()Ljava/lang/String;", "meterOutputs", "actionMeter", "Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;", "addCloseable", "", "closeable", "close", "loadProcessContainer", "seededRandom", "Lcom/atlassian/performance/tools/jiraactions/api/SeededRandom;", "singleThreadLoad", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserLoad;", "taskMeter", "threadResult", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserResult;", "Factory", "virtual-users"})
public final class LoadThreadContainer
implements AutoCloseable {
    private final Queue<AutoCloseable> meterOutputs;
    private final Queue<AutoCloseable> closeables;
    @NotNull
    private final String id;
    private final LoadProcessContainer processContainer;
    private final int index;
    private final UUID uuid;
    public static final Factory Factory = new Factory(null);

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final VirtualUserResult threadResult() {
        return this.processContainer.result().isolateVuResult$virtual_users(this.id);
    }

    @NotNull
    public final SeededRandom seededRandom() {
        return new SeededRandom(this.processContainer.seededRandom().getRandom().nextLong());
    }

    @NotNull
    public final ActionMeter actionMeter() {
        BufferedWriter actionOutput = this.threadResult().writeActionMetrics$virtual_users();
        this.meterOutputs.add(actionOutput);
        return new ActionMeter.Builder((ActionMetricOutput)new AppendableActionMetricOutput((Appendable)actionOutput)).virtualUser(this.uuid).build();
    }

    @NotNull
    public final ActionMeter taskMeter() {
        BufferedWriter taskOutput = this.threadResult().writeTaskMetrics$virtual_users();
        this.meterOutputs.add(taskOutput);
        return new ActionMeter.Builder((ActionMetricOutput)new AppendableActionMetricOutput((Appendable)taskOutput)).virtualUser(this.uuid).build();
    }

    @NotNull
    public final VirtualUserLoad singleThreadLoad() {
        VirtualUserLoad overallLoad = this.processContainer.options().getBehavior().getLoad();
        Duration singleThreadHold = overallLoad.getHold().plus(overallLoad.getRampInterval().multipliedBy(this.index));
        VirtualUserLoad.Builder builder = new VirtualUserLoad.Builder().virtualUsers(1);
        Duration duration = singleThreadHold;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"singleThreadHold");
        VirtualUserLoad.Builder builder2 = builder.hold(duration);
        Duration duration2 = Duration.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ZERO");
        VirtualUserLoad.Builder builder3 = builder2.ramp(duration2);
        Duration duration3 = overallLoad.getTotal().minus(singleThreadHold);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"overallLoad.total - singleThreadHold");
        return builder3.flat(duration3).maxOverallLoad(overallLoad.getMaxOverallLoad().div(overallLoad.getVirtualUsers())).build();
    }

    @NotNull
    public final LoadProcessContainer loadProcessContainer() {
        return this.processContainer;
    }

    public final void addCloseable(@NotNull AutoCloseable closeable) {
        Intrinsics.checkParameterIsNotNull((Object)closeable, (String)"closeable");
        this.closeables.add(closeable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LoadThreadContainer loadThreadContainer = this;
        synchronized (loadThreadContainer) {
            AutoCloseable it;
            boolean bl = false;
            Iterable $receiver$iv = this.meterOutputs;
            for (Object element$iv : $receiver$iv) {
                it = (AutoCloseable)element$iv;
                boolean bl2 = false;
                it.close();
            }
            this.meterOutputs.clear();
            $receiver$iv = this.closeables;
            for (Object element$iv : $receiver$iv) {
                it = (AutoCloseable)element$iv;
                boolean bl3 = false;
                it.close();
            }
            this.closeables.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private LoadThreadContainer(LoadProcessContainer processContainer, int index, UUID uuid) {
        this.processContainer = processContainer;
        this.index = index;
        this.uuid = uuid;
        this.meterOutputs = new ConcurrentLinkedQueue();
        this.closeables = new ConcurrentLinkedQueue();
        String string = this.uuid.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uuid.toString()");
        this.id = string;
    }

    public /* synthetic */ LoadThreadContainer(LoadProcessContainer processContainer, int index, UUID uuid, DefaultConstructorMarker $constructor_marker) {
        this(processContainer, index, uuid);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/config/LoadThreadContainer$Factory;", "", "()V", "create", "Lcom/atlassian/performance/tools/virtualusers/api/config/LoadThreadContainer;", "processContainer", "Lcom/atlassian/performance/tools/virtualusers/api/config/LoadProcessContainer;", "index", "", "uuid", "Ljava/util/UUID;", "virtual-users"})
    public static final class Factory {
        @NotNull
        public final LoadThreadContainer create(@NotNull LoadProcessContainer processContainer, int index, @NotNull UUID uuid) {
            Intrinsics.checkParameterIsNotNull((Object)processContainer, (String)"processContainer");
            Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
            return new LoadThreadContainer(processContainer, index, uuid, null);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

