/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api;

import com.atlassian.performance.tools.virtualusers.api.TemporalRate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B/\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00000\u001d2\u0006\u0010\u001e\u001a\u00020\u0003J\b\u0010\u001f\u001a\u00020 H\u0016J\u001d\u0010!\u001a\n \"*\u0004\u0018\u00010\u00050\u0005*\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0082\u0002R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserLoad;", "", "virtualUsers", "", "hold", "Ljava/time/Duration;", "ramp", "flat", "(ILjava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;)V", "maxOverallLoad", "Lcom/atlassian/performance/tools/virtualusers/api/TemporalRate;", "(ILjava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Lcom/atlassian/performance/tools/virtualusers/api/TemporalRate;)V", "getFlat", "()Ljava/time/Duration;", "getHold", "getMaxOverallLoad", "()Lcom/atlassian/performance/tools/virtualusers/api/TemporalRate;", "getRamp", "rampInterval", "getRampInterval", "total", "getTotal", "getVirtualUsers", "()I", "equals", "", "other", "hashCode", "slice", "", "slices", "toString", "", "times", "kotlin.jvm.PlatformType", "factor", "", "Builder", "virtual-users"})
public final class VirtualUserLoad {
    @NotNull
    private final Duration total;
    @NotNull
    private final Duration rampInterval;
    private final int virtualUsers;
    @NotNull
    private final Duration hold;
    @NotNull
    private final Duration ramp;
    @NotNull
    private final Duration flat;
    @NotNull
    private final TemporalRate maxOverallLoad;

    @NotNull
    public final Duration getTotal() {
        return this.total;
    }

    @NotNull
    public final Duration getRampInterval() {
        return this.rampInterval;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualUserLoad> slice(int slices) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if (slices > this.virtualUsers) {
            throw (Throwable)new Exception(this.virtualUsers + " virtual users are not enough to slice into " + slices);
        }
        int vusPerSlice = this.virtualUsers / slices;
        Duration rampPerSlice = this.ramp.dividedBy(slices);
        Iterable iterable = $receiver$iv = (Iterable)RangesKt.until((long)0L, (int)slices);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void slice;
            long item$iv$iv;
            long l = item$iv$iv = ((LongIterator)iterator).nextLong();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long slicesAbove = (long)slices - slice - 1L;
            Builder builder = new Builder().virtualUsers(vusPerSlice);
            Duration duration = rampPerSlice;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"rampPerSlice");
            Duration duration2 = this.hold.plus(this.times(duration, (long)slice));
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"hold + rampPerSlice * slice");
            Builder builder2 = builder.hold(duration2).ramp(rampPerSlice);
            Duration duration3 = this.flat.plus(this.times(rampPerSlice, slicesAbove));
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"flat + rampPerSlice * slicesAbove");
            VirtualUserLoad virtualUserLoad = builder2.flat(duration3).maxOverallLoad(this.maxOverallLoad.div(slices)).build();
            collection.add(virtualUserLoad);
        }
        return (List)destination$iv$iv;
    }

    private final Duration times(Duration $receiver, long factor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.multipliedBy(factor);
    }

    @NotNull
    public String toString() {
        return "VirtualUserLoad(" + "virtualUsers=" + this.virtualUsers + ", " + "hold=" + this.hold + ", " + "ramp=" + this.ramp + ", " + "flat=" + this.flat + ", " + "maxOverallLoad=" + this.maxOverallLoad + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.atlassian.performance.tools.virtualusers.api.VirtualUserLoad");
        }
        VirtualUserLoad cfr_ignored_0 = (VirtualUserLoad)object2;
        if (this.virtualUsers != ((VirtualUserLoad)other).virtualUsers) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.hold, (Object)((VirtualUserLoad)other).hold) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.ramp, (Object)((VirtualUserLoad)other).ramp) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.flat, (Object)((VirtualUserLoad)other).flat) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.maxOverallLoad, (Object)((VirtualUserLoad)other).maxOverallLoad) ^ true);
    }

    public int hashCode() {
        int result = this.virtualUsers;
        result = 31 * result + this.hold.hashCode();
        result = 31 * result + this.ramp.hashCode();
        result = 31 * result + this.flat.hashCode();
        result = 31 * result + this.maxOverallLoad.hashCode();
        return result;
    }

    public final int getVirtualUsers() {
        return this.virtualUsers;
    }

    @NotNull
    public final Duration getHold() {
        return this.hold;
    }

    @NotNull
    public final Duration getRamp() {
        return this.ramp;
    }

    @NotNull
    public final Duration getFlat() {
        return this.flat;
    }

    @NotNull
    public final TemporalRate getMaxOverallLoad() {
        return this.maxOverallLoad;
    }

    private VirtualUserLoad(int virtualUsers, Duration hold, Duration ramp, Duration flat, TemporalRate maxOverallLoad) {
        this.virtualUsers = virtualUsers;
        this.hold = hold;
        this.ramp = ramp;
        this.flat = flat;
        this.maxOverallLoad = maxOverallLoad;
        Duration duration = this.hold.plus(this.ramp).plus(this.flat);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"hold + ramp + flat");
        this.total = duration;
        Duration duration2 = this.ramp.dividedBy(this.virtualUsers);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"ramp.dividedBy(virtualUsers.toLong())");
        this.rampInterval = duration2;
    }

    @Deprecated(message="Use VirtualUserLoad.Builder instead")
    public VirtualUserLoad(int virtualUsers, @NotNull Duration hold, @NotNull Duration ramp, @NotNull Duration flat) {
        Intrinsics.checkParameterIsNotNull((Object)hold, (String)"hold");
        Intrinsics.checkParameterIsNotNull((Object)ramp, (String)"ramp");
        Intrinsics.checkParameterIsNotNull((Object)flat, (String)"flat");
        Duration duration = Duration.ofSeconds(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(1)");
        this(virtualUsers, hold, ramp, flat, new TemporalRate(10.0, duration));
    }

    public /* synthetic */ VirtualUserLoad(int n, Duration duration, Duration duration2, Duration duration3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        if ((n2 & 2) != 0) {
            Duration duration4 = Duration.ZERO;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ZERO");
            duration = duration4;
        }
        if ((n2 & 4) != 0) {
            Duration duration5 = Duration.ofSeconds(15L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration5, (String)"Duration.ofSeconds(15)");
            duration2 = duration5;
        }
        if ((n2 & 8) != 0) {
            Duration duration6 = Duration.ofMinutes(5L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration6, (String)"Duration.ofMinutes(5)");
            duration3 = duration6;
        }
        this(n, duration, duration2, duration3);
    }

    public /* synthetic */ VirtualUserLoad(int virtualUsers, Duration hold, Duration ramp, Duration flat, TemporalRate maxOverallLoad, DefaultConstructorMarker $constructor_marker) {
        this(virtualUsers, hold, ramp, flat, maxOverallLoad);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserLoad$Builder;", "", "()V", "flat", "Ljava/time/Duration;", "hold", "maxOverallLoad", "Lcom/atlassian/performance/tools/virtualusers/api/TemporalRate;", "ramp", "virtualUsers", "", "build", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserLoad;", "virtual-users"})
    public static final class Builder {
        private int virtualUsers = 10;
        private Duration hold;
        private Duration ramp;
        private Duration flat;
        private TemporalRate maxOverallLoad;

        @NotNull
        public final Builder virtualUsers(int virtualUsers) {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.virtualUsers = virtualUsers;
            return builder;
        }

        @NotNull
        public final Builder hold(@NotNull Duration hold) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)hold, (String)"hold");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.hold = hold;
            return builder;
        }

        @NotNull
        public final Builder ramp(@NotNull Duration ramp) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)ramp, (String)"ramp");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.ramp = ramp;
            return builder;
        }

        @NotNull
        public final Builder flat(@NotNull Duration flat) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)flat, (String)"flat");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.flat = flat;
            return builder;
        }

        @NotNull
        public final Builder maxOverallLoad(@NotNull TemporalRate maxOverallLoad) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)maxOverallLoad, (String)"maxOverallLoad");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.maxOverallLoad = maxOverallLoad;
            return builder;
        }

        @NotNull
        public final VirtualUserLoad build() {
            return new VirtualUserLoad(this.virtualUsers, this.hold, this.ramp, this.flat, this.maxOverallLoad, null);
        }

        public Builder() {
            Duration duration = Duration.ZERO;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ZERO");
            this.hold = duration;
            Duration duration2 = Duration.ofSeconds(15L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofSeconds(15)");
            this.ramp = duration2;
            Duration duration3 = Duration.ofMinutes(5L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofMinutes(5)");
            this.flat = duration3;
            Duration duration4 = Duration.ofSeconds(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ofSeconds(1)");
            this.maxOverallLoad = new TemporalRate(10.0, duration4);
        }
    }
}

