/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\fH\u0086\u0002J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\fH\u0016J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u00152\u0006\u0010\r\u001a\u00020\u0000H\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0005J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003H\u0086\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/TemporalRate;", "", "change", "", "time", "Ljava/time/Duration;", "(DLjava/time/Duration;)V", "getChange", "()D", "getTime", "()Ljava/time/Duration;", "compareTo", "", "other", "div", "divisor", "equals", "", "", "hashCode", "normalizeTimes", "Lkotlin/Pair;", "scaleChange", "newChange", "scaleTime", "newTime", "times", "factor", "toString", "", "virtual-users"})
public final class TemporalRate
implements Comparable<TemporalRate> {
    private final double change;
    @NotNull
    private final Duration time;

    @NotNull
    public final TemporalRate scaleChange(double newChange) {
        if (this.change == newChange) {
            return this;
        }
        double factor = newChange / this.change;
        Duration duration = Duration.ofNanos(MathKt.roundToLong((double)((double)this.time.toNanos() * factor)));
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofNanos((time.t\u2026 * factor).roundToLong())");
        return new TemporalRate(newChange, duration);
    }

    @NotNull
    public final TemporalRate scaleTime(@NotNull Duration newTime) {
        Intrinsics.checkParameterIsNotNull((Object)newTime, (String)"newTime");
        if (Intrinsics.areEqual((Object)this.time, (Object)newTime)) {
            return this;
        }
        double factor = (double)newTime.toMillis() / (double)this.time.toMillis();
        return new TemporalRate(this.change * factor, newTime);
    }

    @NotNull
    public final TemporalRate times(double factor) {
        return new TemporalRate(this.change * factor, this.time);
    }

    @NotNull
    public final TemporalRate div(int divisor) {
        return new TemporalRate(this.change / (double)divisor, this.time);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(@NotNull TemporalRate other) {
        void normalizedThis;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Pair<TemporalRate, TemporalRate> pair = this.normalizeTimes(other);
        TemporalRate temporalRate = (TemporalRate)pair.component1();
        TemporalRate normalizedOther = (TemporalRate)pair.component2();
        return ComparisonsKt.compareValues((Comparable)Double.valueOf(normalizedThis.change), (Comparable)Double.valueOf(normalizedOther.change));
    }

    private final Pair<TemporalRate, TemporalRate> normalizeTimes(TemporalRate other) {
        Duration shorterTime = (Duration)ComparisonsKt.minOf((Comparable)this.time, (Comparable)other.time);
        return new Pair((Object)this.scaleTime(shorterTime), (Object)other.scaleTime(shorterTime));
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object other) {
        void normalizedThis;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.atlassian.performance.tools.virtualusers.api.TemporalRate");
        }
        TemporalRate cfr_ignored_0 = (TemporalRate)object2;
        Pair<TemporalRate, TemporalRate> pair = this.normalizeTimes((TemporalRate)other);
        TemporalRate temporalRate = (TemporalRate)pair.component1();
        TemporalRate normalizedOther = (TemporalRate)pair.component2();
        if (normalizedThis.change != normalizedOther.change) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)normalizedThis.time, (Object)normalizedOther.time) ^ true);
    }

    public int hashCode() {
        Duration duration = Duration.ofMillis(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMillis(1)");
        TemporalRate standardized = this.scaleTime(duration);
        int result = Double.hashCode(standardized.change);
        result = 31 * result + standardized.time.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return this.change + " over " + this.time;
    }

    public final double getChange() {
        return this.change;
    }

    @NotNull
    public final Duration getTime() {
        return this.time;
    }

    public TemporalRate(double change, @NotNull Duration time) {
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
        this.change = change;
        this.time = time;
    }
}

