/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jirasoftwareactions.api.page;

import com.atlassian.performance.tools.jiraactions.api.page.NotificationPopUps;
import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import com.atlassian.performance.tools.jirasoftwareactions.api.page.SprintOnBacklog;
import com.atlassian.performance.tools.jirasoftwareactions.webdriver.JavaScriptUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000eJ\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/performance/tools/jirasoftwareactions/api/page/ViewBacklogPage;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "(Lorg/openqa/selenium/WebDriver;)V", "popUps", "Lcom/atlassian/performance/tools/jiraactions/api/page/NotificationPopUps;", "sprintsLocator", "Lorg/openqa/selenium/By;", "kotlin.jvm.PlatformType", "closePopups", "", "getIssueKeys", "", "", "listSprints", "Lcom/atlassian/performance/tools/jirasoftwareactions/api/page/SprintOnBacklog;", "validateSprintName", "expectedSprintName", "waitForBacklog", "Lorg/openqa/selenium/WebElement;", "jira-software-actions"})
public final class ViewBacklogPage {
    private final By sprintsLocator;
    private final NotificationPopUps popUps;
    private final WebDriver driver;

    @Nullable
    public final WebElement waitForBacklog() {
        Duration duration = Duration.ofSeconds(30L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(30)");
        ExpectedCondition expectedCondition = ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)"#ghx-backlog[data-rendered]:not(.browser-metrics-stale)"));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"presenceOfElementLocated\u2026browser-metrics-stale)\"))");
        return (WebElement)WebDriverUtils.wait$default((WebDriver)this.driver, (Duration)duration, (ExpectedCondition)expectedCondition, null, (int)4, null);
    }

    @NotNull
    public final List<String> getIssueKeys() {
        return (List)JavaScriptUtils.Companion.executeScript(this.driver, "return Array.from(document.getElementsByClassName('js-issue'), i => i.getAttribute('data-issue-key'))", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SprintOnBacklog> listSprints() {
        void var3_3;
        void $receiver$iv$iv;
        List list = this.driver.findElements(this.sprintsLocator);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"driver\n        .findElements(sprintsLocator)");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            WebElement webElement = (WebElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            SprintOnBacklog sprintOnBacklog = new SprintOnBacklog(this.driver, (WebElement)v1);
            collection.add(sprintOnBacklog);
        }
        return (List)var3_3;
    }

    public final void validateSprintName(@NotNull String expectedSprintName) {
        Intrinsics.checkParameterIsNotNull((Object)expectedSprintName, (String)"expectedSprintName");
        Duration duration = Duration.ofSeconds(30L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(30)");
        ExpectedCondition expectedCondition = ExpectedConditions.textToBePresentInElementLocated((By)By.cssSelector((String)".ghx-backlog-container .ghx-name"), (String)expectedSprintName);
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"textToBePresentInElement\u2026me\"), expectedSprintName)");
        WebDriverUtils.wait$default((WebDriver)this.driver, (Duration)duration, (ExpectedCondition)expectedCondition, null, (int)4, null);
    }

    public final void closePopups() {
        this.popUps.waitUntilAuiFlagsAreGone();
    }

    public ViewBacklogPage(@NotNull WebDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.driver = driver;
        this.sprintsLocator = By.cssSelector((String)".ghx-sprint-group .ghx-backlog-container");
        this.popUps = new NotificationPopUps(this.driver);
    }
}

