/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.w3c.harvesters;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0000\u00a8\u0006\u0007"}, d2={"parseInstantMilli", "Ljava/time/Instant;", "milli", "", "parseTimestamp", "Ljava/time/Duration;", "timestamp", "jira-actions"})
public final class CommonKt {
    @NotNull
    public static final Duration parseTimestamp(@Nullable Object timestamp) {
        Duration duration;
        Object object = timestamp;
        if (object instanceof Long) {
            Duration duration2 = Duration.ofMillis(((Number)timestamp).longValue());
            duration = duration2;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMillis(timestamp)");
        } else if (object instanceof Double) {
            Duration duration3 = Duration.ofMillis((long)((Number)timestamp).doubleValue());
            duration = duration3;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofMillis(timestamp.toLong())");
        } else {
            throw (Throwable)new Exception("Cannot parse timestamp from " + timestamp);
        }
        return duration;
    }

    @NotNull
    public static final Instant parseInstantMilli(@Nullable Object milli) {
        Instant instant;
        Object object = milli;
        if (object instanceof Long) {
            Instant instant2 = Instant.ofEpochMilli(((Number)milli).longValue());
            instant = instant2;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"Instant.ofEpochMilli(milli)");
        } else if (object instanceof Double) {
            double d = ((Number)milli).doubleValue();
            long wholeMilli = (long)Math.floor(d);
            double remainderMilli = ((Number)milli).doubleValue() - (double)wholeMilli;
            long remainderNanos = (long)(remainderMilli * (double)1000000);
            Instant instant3 = Instant.ofEpochMilli(wholeMilli).plusNanos(remainderNanos);
            instant = instant3;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant3, (String)"Instant.ofEpochMilli(who\u2026plusNanos(remainderNanos)");
        } else {
            throw (Throwable)new Exception("Cannot parse instant from " + milli);
        }
        return instant;
    }
}

