/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.seleniumjs.NativeExpectedCondition;
import com.atlassian.performance.seleniumjs.NativeExpectedConditions;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a(\u0010\u0007\u001a\u00020\u0006*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\tH\u0007\u001a7\u0010\u0007\u001a\u0002H\r\"\u0004\b\u0000\u0010\r*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\r0\u000e2\b\b\u0002\u0010\f\u001a\u00020\tH\u0007\u00a2\u0006\u0002\u0010\u000f\u001a%\u0010\u0007\u001a\u0002H\r\"\u0004\b\u0000\u0010\r*\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\r0\u000eH\u0000\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"isElementPresent", "", "Lorg/openqa/selenium/WebDriver;", "locator", "Lorg/openqa/selenium/By;", "tolerateDirtyFormsOnCurrentPage", "", "wait", "timeout", "Ljava/time/Duration;", "condition", "Lcom/atlassian/performance/seleniumjs/NativeExpectedCondition;", "precision", "T", "Lorg/openqa/selenium/support/ui/ExpectedCondition;", "(Lorg/openqa/selenium/WebDriver;Ljava/time/Duration;Lorg/openqa/selenium/support/ui/ExpectedCondition;Ljava/time/Duration;)Ljava/lang/Object;", "(Lorg/openqa/selenium/WebDriver;Lorg/openqa/selenium/support/ui/ExpectedCondition;)Ljava/lang/Object;", "jira-actions"})
@JvmName(name="WebDriverUtils")
public final class WebDriverUtils {
    @JvmOverloads
    public static final <T> T wait(@NotNull WebDriver $receiver, @NotNull Duration timeout, @NotNull ExpectedCondition<T> condition, @NotNull Duration precision) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        Intrinsics.checkParameterIsNotNull((Object)precision, (String)"precision");
        return (T)new WebDriverWait($receiver, timeout.getSeconds(), precision.toMillis()).until((Function)condition);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ Object wait$default(WebDriver webDriver, Duration duration, ExpectedCondition expectedCondition, Duration duration2, int n, Object object) {
        if ((n & 4) != 0) {
            Duration duration3 = Duration.ofMillis(100L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofMillis(100)");
            duration2 = duration3;
        }
        return WebDriverUtils.wait(webDriver, duration, expectedCondition, duration2);
    }

    @JvmOverloads
    public static final <T> T wait(@NotNull WebDriver $receiver, @NotNull Duration timeout, @NotNull ExpectedCondition<T> condition) {
        return (T)WebDriverUtils.wait$default($receiver, timeout, condition, null, 4, null);
    }

    @JvmOverloads
    public static final void wait(@NotNull WebDriver $receiver, @NotNull Duration timeout, @NotNull NativeExpectedCondition condition, @NotNull Duration precision) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Intrinsics.checkParameterIsNotNull((Object)condition, (String)"condition");
        Intrinsics.checkParameterIsNotNull((Object)precision, (String)"precision");
        new WebDriverWait($receiver, timeout.getSeconds(), precision.toMillis()).until((Function)NativeExpectedConditions.Companion.toSeleniumCondition(condition));
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void wait$default(WebDriver webDriver, Duration duration, NativeExpectedCondition nativeExpectedCondition, Duration duration2, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration3 = Duration.ofSeconds(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofSeconds(10)");
            duration = duration3;
        }
        if ((n & 4) != 0) {
            Duration duration4 = Duration.ofMillis(100L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ofMillis(100)");
            duration2 = duration4;
        }
        WebDriverUtils.wait(webDriver, duration, nativeExpectedCondition, duration2);
    }

    @JvmOverloads
    public static final void wait(@NotNull WebDriver $receiver, @NotNull Duration timeout, @NotNull NativeExpectedCondition condition) {
        WebDriverUtils.wait$default($receiver, timeout, condition, null, 4, null);
    }

    @JvmOverloads
    public static final void wait(@NotNull WebDriver $receiver, @NotNull NativeExpectedCondition condition) {
        WebDriverUtils.wait$default($receiver, null, condition, null, 5, null);
    }

    public static final <T> T wait(@NotNull WebDriver $receiver, @NotNull ExpectedCondition<T> condition) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(10)");
        return (T)WebDriverUtils.wait$default($receiver, duration, condition, null, 4, null);
    }

    public static final boolean isElementPresent(@NotNull WebDriver $receiver, @NotNull By locator) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)locator, (String)"locator");
        List list = $receiver.findElements(locator);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.findElements(locator)");
        Collection collection = list;
        return !collection.isEmpty();
    }

    public static final void tolerateDirtyFormsOnCurrentPage(@NotNull WebDriver $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ((JavascriptExecutor)$receiver).executeScript("window.onbeforeunload = null", new Object[0]);
    }
}

