/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/RichTextEditorTextArea;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "textArea", "Lorg/openqa/selenium/WebElement;", "(Lorg/openqa/selenium/WebDriver;Lorg/openqa/selenium/WebElement;)V", "overwriteIfPresent", "", "text", "", "overwritePlain", "overwriteRich", "jira-actions"})
public final class RichTextEditorTextArea {
    private final WebDriver driver;
    private final WebElement textArea;

    public final void overwriteIfPresent(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String attrClass = this.textArea.getAttribute("class");
        if (attrClass != null && StringsKt.contains((CharSequence)attrClass, (CharSequence)"richeditor-cover", (boolean)true)) {
            this.overwriteRich(text);
        } else {
            this.overwritePlain(text);
        }
    }

    private final void overwritePlain(String text) {
        ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((WebElement)this.textArea);
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(textArea)");
        WebDriverUtils.wait(this.driver, expectedCondition);
        this.textArea.clear();
        this.textArea.sendKeys(new CharSequence[]{text});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void overwriteRich(String text) {
        String iframeXpath = "//div[textarea[@id='" + this.textArea.getAttribute("id") + "']]//iframe";
        try {
            ExpectedCondition expectedCondition = ExpectedConditions.frameToBeAvailableAndSwitchToIt((By)By.xpath((String)iframeXpath));
            Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"frameToBeAvailableAndSwi\u2026It(By.xpath(iframeXpath))");
            WebDriverUtils.wait(this.driver, expectedCondition);
            WebElement tinyMce = this.driver.findElement(By.id((String)"tinymce"));
            ExpectedCondition expectedCondition2 = ExpectedConditions.attributeToBeNotEmpty((WebElement)tinyMce, (String)"data-projectkey");
            Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition2, (String)"attributeToBeNotEmpty(tinyMce, \"data-projectkey\")");
            WebDriverUtils.wait(this.driver, expectedCondition2);
            tinyMce.clear();
            tinyMce.sendKeys(new CharSequence[]{text});
        }
        finally {
            this.driver.switchTo().parentFrame();
        }
    }

    public RichTextEditorTextArea(@NotNull WebDriver driver, @NotNull WebElement textArea) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)textArea, (String)"textArea");
        this.driver = driver;
        this.textArea = textArea;
    }
}

