/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import com.atlassian.performance.tools.jiraactions.api.webdriver.JavaScriptUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0006\u0010\n\u001a\u00020\u0000J\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000J\u0006\u0010\u0010\u001a\u00020\u0000J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/NotificationPopUps;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "(Lorg/openqa/selenium/WebDriver;)V", "auiFlagCloseLocator", "Lorg/openqa/selenium/By;", "kotlin.jvm.PlatformType", "clickAll", "locator", "disableNpsFeedback", "dismissAuiFlags", "dismissFindYourWorkFaster", "dismissHealthCheckNotifications", "dismissJiraHelpTips", "dismissPostSetup", "waitUntilAuiFlagsAreGone", "waitUntilAuiFlagsAreInvisible", "", "jira-actions"})
public final class NotificationPopUps {
    private final By auiFlagCloseLocator;
    private final WebDriver driver;

    @NotNull
    public final NotificationPopUps dismissHealthCheckNotifications() {
        By by = By.cssSelector((String)".dismiss-notification");
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.cssSelector(\".dismiss-notification\")");
        return this.clickAll(by);
    }

    @NotNull
    public final NotificationPopUps waitUntilAuiFlagsAreGone() {
        try {
            this.waitUntilAuiFlagsAreInvisible();
            return this;
        }
        catch (TimeoutException timeoutException) {
            try {
                this.dismissAuiFlags();
                this.waitUntilAuiFlagsAreInvisible();
                return this;
            }
            catch (Exception e) {
                throw (Throwable)e;
            }
        }
    }

    private final void waitUntilAuiFlagsAreInvisible() {
        ExpectedCondition expectedCondition = ExpectedConditions.invisibilityOfElementLocated((By)By.id((String)"aui-flag-container"));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"invisibilityOfElementLoc\u2026id(\"aui-flag-container\"))");
        WebDriverUtils.wait(this.driver, expectedCondition);
    }

    @NotNull
    public final NotificationPopUps dismissAuiFlags() {
        By by = this.auiFlagCloseLocator;
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"auiFlagCloseLocator");
        return this.clickAll(by);
    }

    @NotNull
    public final NotificationPopUps dismissFindYourWorkFaster() {
        By by = By.cssSelector((String)".aui-button.helptip-close");
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.cssSelector(\".aui-button.helptip-close\")");
        return this.clickAll(by);
    }

    @NotNull
    public final NotificationPopUps disableNpsFeedback() {
        By by = By.id((String)"nps-acknowledgement-accept-button");
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.id(\"nps-acknowledgement-accept-button\")");
        return this.clickAll(by);
    }

    @NotNull
    public final NotificationPopUps dismissJiraHelpTips() {
        By by = By.cssSelector((String)".jira-help-tip .cancel");
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.cssSelector(\".jira-help-tip .cancel\")");
        return this.clickAll(by);
    }

    @NotNull
    public final NotificationPopUps dismissPostSetup() {
        By by = By.className((String)"postsetup-close-link");
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.className(\"postsetup-close-link\")");
        return this.clickAll(by);
    }

    private final NotificationPopUps clickAll(By locator) {
        List list = this.driver.findElements(locator);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"driver.findElements(locator)");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            WebElement it = (WebElement)element$iv;
            Object[] objectArray = new Object[1];
            WebElement webElement = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"it");
            objectArray[0] = webElement;
            JavaScriptUtils.Companion.executeScript(this.driver, "arguments[0].click()", objectArray);
        }
        return this;
    }

    public NotificationPopUps(@NotNull WebDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.driver = driver;
        this.auiFlagCloseLocator = By.cssSelector((String)".aui-flag .icon-close, .aui-flag .aui-close-button");
    }
}

