/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.tools.jiraactions.api.page.JiraErrors;
import com.atlassian.performance.tools.jiraactions.api.page.NotificationPopUps;
import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import com.atlassian.performance.tools.jiraactions.api.page.form.IssueForm;
import com.atlassian.performance.tools.jiraactions.api.webdriver.HardenedKeyboardKt;
import com.atlassian.performance.tools.jiraactions.page.SingleSelect;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementClickInterceptedException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u0000J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001eJ\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0006H\u0002J \u0010\"\u001a\u00020\u00002\u0018\u0010#\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u001e\u0012\u0004\u0012\u00020\u00180$J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0018J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0018J\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020\u0011J\u0006\u0010*\u001a\u00020\u0000J\b\u0010+\u001a\u00020\u0011H\u0002J\b\u0010,\u001a\u00020\u0011H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/IssueCreateDialog;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "(Lorg/openqa/selenium/WebDriver;)V", "configColumnField", "Lorg/openqa/selenium/By;", "kotlin.jvm.PlatformType", "dialog", "form", "Lcom/atlassian/performance/tools/jiraactions/api/page/form/IssueForm;", "issueTypeField", "Lcom/atlassian/performance/tools/jiraactions/page/SingleSelect;", "popUps", "Lcom/atlassian/performance/tools/jiraactions/api/page/NotificationPopUps;", "projectField", "dismissConfigureFieldsDialog", "", "elementIsFocused", "Lorg/openqa/selenium/support/ui/ExpectedCondition;", "Lorg/openqa/selenium/WebElement;", "locator", "fill", "fieldId", "", "value", "fillRequiredFields", "getFieldsSelectLocator", "dialogClass", "getIssueTypes", "", "getVisibleAllFieldsLinkLocator", "openConfigureFieldsDialog", "popupLocator", "selectIssueType", "picker", "Lkotlin/Function1;", "issueType", "selectProject", "projectName", "showAllFields", "submit", "waitForDialog", "waitForDialogToHide", "waitUntilSummaryIsFocused", "jira-actions"})
public final class IssueCreateDialog {
    private final NotificationPopUps popUps;
    private final IssueForm form;
    private final SingleSelect projectField;
    private final SingleSelect issueTypeField;
    private final By configColumnField;
    private final By dialog;
    private final WebDriver driver;

    @NotNull
    public final IssueCreateDialog waitForDialog() {
        JiraErrors jiraErrors = new JiraErrors(this.driver);
        ExpectedCondition expectedCondition = ExpectedConditions.or((ExpectedCondition[])new ExpectedCondition[]{ExpectedConditions.visibilityOfElementLocated((By)this.dialog), jiraErrors.anyCommonError()});
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"or(\n                visi\u2026mmonError()\n            )");
        WebDriverUtils.wait(this.driver, expectedCondition);
        jiraErrors.assertNoErrors();
        WebDriverUtils.tolerateDirtyFormsOnCurrentPage(this.driver);
        return this;
    }

    private final void waitForDialogToHide() {
        ExpectedCondition expectedCondition = ExpectedConditions.invisibilityOfElementLocated((By)this.dialog);
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"invisibilityOfElementLocated(dialog)");
        WebDriverUtils.wait(this.driver, expectedCondition);
    }

    @NotNull
    public final IssueCreateDialog selectProject(@NotNull String projectName) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        return (IssueCreateDialog)this.form.waitForRefresh(new Supplier<IssueCreateDialog>(this, projectName){
            final /* synthetic */ IssueCreateDialog this$0;
            final /* synthetic */ String $projectName;

            @NotNull
            public final IssueCreateDialog get() {
                IssueCreateDialog.access$getProjectField$p(this.this$0).select(this.$projectName);
                IssueCreateDialog.access$waitUntilSummaryIsFocused(this.this$0);
                return this.this$0;
            }
            {
                this.this$0 = issueCreateDialog;
                this.$projectName = string;
            }
        });
    }

    @NotNull
    public final IssueCreateDialog selectIssueType(@NotNull String issueType) {
        Intrinsics.checkParameterIsNotNull((Object)issueType, (String)"issueType");
        return (IssueCreateDialog)this.form.waitForRefresh(new Supplier<IssueCreateDialog>(this, issueType){
            final /* synthetic */ IssueCreateDialog this$0;
            final /* synthetic */ String $issueType;

            @NotNull
            public final IssueCreateDialog get() {
                IssueCreateDialog.access$getIssueTypeField$p(this.this$0).select(this.$issueType);
                return this.this$0;
            }
            {
                this.this$0 = issueCreateDialog;
                this.$issueType = string;
            }
        });
    }

    @NotNull
    public final IssueCreateDialog selectIssueType(@NotNull Function1<? super List<String>, String> picker) {
        Intrinsics.checkParameterIsNotNull(picker, (String)"picker");
        return (IssueCreateDialog)this.form.waitForRefresh(new Supplier<IssueCreateDialog>(this, picker){
            final /* synthetic */ IssueCreateDialog this$0;
            final /* synthetic */ Function1 $picker;

            @NotNull
            public final IssueCreateDialog get() {
                IssueCreateDialog.access$getIssueTypeField$p(this.this$0).select((Function1<? super List<String>, String>)this.$picker);
                return this.this$0;
            }
            {
                this.this$0 = issueCreateDialog;
                this.$picker = function1;
            }
        });
    }

    @NotNull
    public final List<String> getIssueTypes() {
        return CollectionsKt.plus((Collection)this.issueTypeField.getSuggestions(), (Object)this.issueTypeField.getCurrentValue());
    }

    @NotNull
    public final IssueCreateDialog fill(@NotNull String fieldId, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldId, (String)"fieldId");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        WebElement webElement = this.driver.findElement(By.id((String)fieldId));
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(By.id(fieldId))");
        HardenedKeyboardKt.sendKeysWhenClickable(webElement, this.driver, value);
        return this;
    }

    @NotNull
    public final IssueCreateDialog showAllFields() {
        String configureFieldsDialogClass = "qf-picker";
        By dialogLocator = By.className((String)configureFieldsDialogClass);
        By selectLocator = this.getFieldsSelectLocator(configureFieldsDialogClass);
        boolean newConfigureFieldsUi = WebDriverUtils.isElementPresent(this.driver, selectLocator);
        try {
            By by = dialogLocator;
            Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"dialogLocator");
            this.openConfigureFieldsDialog(by);
        }
        catch (TimeoutException e) {
            By by = dialogLocator;
            Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"dialogLocator");
            this.openConfigureFieldsDialog(by);
        }
        if (newConfigureFieldsUi) {
            List list = this.driver.findElements(selectLocator);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"driver\n                .\u2026ndElements(selectLocator)");
            Object object = (WebElement)CollectionsKt.singleOrNull((List)list);
            if (object != null) {
                WebElement it = e = object;
                it = e = new Select(it);
                WebElement webElement = it.getFirstSelectedOption();
                Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"it.firstSelectedOption");
                object = Intrinsics.areEqual((Object)webElement.getText(), (Object)"All Fields") ^ true ? e : null;
                if (object != null) {
                    it = e = object;
                    it.selectByVisibleText("All Fields");
                    ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((By)selectLocator);
                    Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(selectLocator)");
                    WebElement cfr_ignored_0 = (WebElement)WebDriverUtils.wait(this.driver, expectedCondition);
                }
            }
        } else {
            By allFieldsLinkLocator = this.getVisibleAllFieldsLinkLocator(configureFieldsDialogClass);
            if (WebDriverUtils.isElementPresent(this.driver, allFieldsLinkLocator)) {
                ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((By)allFieldsLinkLocator);
                Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(allFieldsLinkLocator)");
                ((WebElement)WebDriverUtils.wait(this.driver, expectedCondition)).click();
                By newAllFieldsLinkLocator = this.getVisibleAllFieldsLinkLocator(configureFieldsDialogClass);
                ExpectedCondition expectedCondition2 = ExpectedConditions.not((ExpectedCondition)ExpectedConditions.elementToBeClickable((By)newAllFieldsLinkLocator));
                Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition2, (String)"not(elementToBeClickable(newAllFieldsLinkLocator))");
                WebDriverUtils.wait(this.driver, expectedCondition2);
            }
        }
        this.dismissConfigureFieldsDialog();
        return this;
    }

    private final By getVisibleAllFieldsLinkLocator(String dialogClass) {
        WebElement webElement = this.driver.findElement(By.cssSelector((String)('.' + dialogClass + " dl:nth-of-type(1)")));
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(By.cs\u2026lass dl:nth-of-type(1)\"))");
        int sectionIndex = webElement.isDisplayed() ? 1 : 2;
        By by = By.xpath((String)("//div[@class='" + dialogClass + "']//dl[" + sectionIndex + "]//dd[1]//a"));
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.xpath(\"//div[@class='\u2026sectionIndex]//dd[1]//a\")");
        return by;
    }

    private final By getFieldsSelectLocator(String dialogClass) {
        By by = By.cssSelector((String)('.' + dialogClass + " #configure-fields"));
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.cssSelector(\".$dialogClass #configure-fields\")");
        return by;
    }

    private final void openConfigureFieldsDialog(By popupLocator) {
        ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((By)this.configColumnField);
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(configColumnField)");
        WebElement configureFields = (WebElement)WebDriverUtils.wait(this.driver, expectedCondition);
        try {
            configureFields.click();
        }
        catch (ElementClickInterceptedException e) {
            this.popUps.dismissHealthCheckNotifications().waitUntilAuiFlagsAreGone();
            configureFields.click();
        }
        ExpectedCondition expectedCondition2 = ExpectedConditions.visibilityOfElementLocated((By)popupLocator);
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition2, (String)"visibilityOfElementLocated(popupLocator)");
        WebDriverUtils.wait(this.driver, expectedCondition2);
    }

    private final void dismissConfigureFieldsDialog() {
        ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id='create-issue-dialog']//*[self::h1 or self::h2]"));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(By.\u2026[self::h1 or self::h2]\"))");
        ((WebElement)WebDriverUtils.wait(this.driver, expectedCondition)).click();
    }

    @NotNull
    public final IssueCreateDialog fillRequiredFields() {
        this.form.fillRequiredFields();
        return this;
    }

    public final void submit() {
        ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((By)By.id((String)"create-issue-submit"));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(By.id(\"create-issue-submit\"))");
        ((WebElement)WebDriverUtils.wait(this.driver, expectedCondition)).click();
        this.waitForDialogToHide();
    }

    private final void waitUntilSummaryIsFocused() {
        By by = By.id((String)"summary");
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.id(\"summary\")");
        WebDriverUtils.wait(this.driver, this.elementIsFocused(by));
    }

    private final ExpectedCondition<WebElement> elementIsFocused(By locator) {
        return (ExpectedCondition)new ExpectedCondition<WebElement>(locator){
            final /* synthetic */ By $locator;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public WebElement apply(@Nullable WebDriver driver) {
                WebElement webElement;
                WebElement webElement3 = (WebElement)ExpectedConditions.elementToBeClickable((By)this.$locator).apply((Object)driver);
                webElement3 = webElement3;
                if (webElement2 == null) return null;
                WebElement it = webElement = webElement3;
                it.click();
                WebElement webElement3 = webElement;
                webElement3 = webElement3;
                if (webElement4 == null) return null;
                it = webElement = webElement3;
                WebDriver webDriver = driver;
                if (webDriver == null) {
                    Intrinsics.throwNpe();
                }
                if (!Intrinsics.areEqual((Object)it, (Object)webDriver.switchTo().activeElement())) return null;
                WebElement webElement5 = webElement;
                return webElement5;
            }

            @NotNull
            public String toString() {
                return "element to be focused: " + this.$locator;
            }
            {
                this.$locator = $captured_local_variable$0;
            }
        };
    }

    public IssueCreateDialog(@NotNull WebDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.driver = driver;
        this.popUps = new NotificationPopUps(this.driver);
        By by = By.cssSelector((String)"form[name=jiraform]");
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.cssSelector(\"form[name=jiraform]\")");
        this.form = new IssueForm(by, this.driver);
        By by2 = By.id((String)"project-field");
        Intrinsics.checkExpressionValueIsNotNull((Object)by2, (String)"By.id(\"project-field\")");
        this.projectField = new SingleSelect(this.driver, by2);
        By by3 = By.id((String)"issuetype-field");
        Intrinsics.checkExpressionValueIsNotNull((Object)by3, (String)"By.id(\"issuetype-field\")");
        this.issueTypeField = new SingleSelect(this.driver, by3);
        this.configColumnField = By.id((String)"qf-field-picker-trigger");
        this.dialog = By.id((String)"create-issue-dialog");
    }

    @NotNull
    public static final /* synthetic */ SingleSelect access$getProjectField$p(IssueCreateDialog $this) {
        return $this.projectField;
    }

    public static final /* synthetic */ void access$waitUntilSummaryIsFocused(IssueCreateDialog $this) {
        $this.waitUntilSummaryIsFocused();
    }

    @NotNull
    public static final /* synthetic */ SingleSelect access$getIssueTypeField$p(IssueCreateDialog $this) {
        return $this.issueTypeField;
    }
}

