/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import com.atlassian.performance.tools.jiraactions.page.WebElementExtensionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u0000J\b\u0010\u000b\u001a\u00020\u0000H\u0002J\u0006\u0010\f\u001a\u00020\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/HistoryTabPanel;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "(Lorg/openqa/selenium/WebDriver;)V", "attemptLimit", "", "loadMoreEntriesLocator", "Lorg/openqa/selenium/By;", "kotlin.jvm.PlatformType", "showAllHistoryEntries", "showMoreEntriesIfNeeded", "waitForActive", "jira-actions"})
public final class HistoryTabPanel {
    private final By loadMoreEntriesLocator;
    private final int attemptLimit = 5;
    private final WebDriver driver;

    @NotNull
    public final HistoryTabPanel showAllHistoryEntries() {
        By by = this.loadMoreEntriesLocator;
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"loadMoreEntriesLocator");
        if (WebDriverUtils.isElementPresent(this.driver, by)) {
            return this.showMoreEntriesIfNeeded();
        }
        ExpectedCondition expectedCondition = ExpectedConditions.invisibilityOfElementLocated((By)By.cssSelector((String)".issuePanelWrapper.loading"));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"invisibilityOfElementLoc\u2026uePanelWrapper.loading\"))");
        WebDriverUtils.wait(this.driver, expectedCondition);
        return this;
    }

    @NotNull
    public final HistoryTabPanel waitForActive() {
        WebElement webElement = this.driver.findElement(By.id((String)"changehistory-tabpanel"));
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(By.id\u2026changehistory-tabpanel\"))");
        WebElementExtensionKt.scrollIntoView(webElement, this.driver).click();
        ExpectedCondition expectedCondition = ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)"#changehistory-tabpanel.active"));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"presenceOfElementLocated\u2026istory-tabpanel.active\"))");
        WebDriverUtils.wait(this.driver, expectedCondition);
        return this;
    }

    private final HistoryTabPanel showMoreEntriesIfNeeded() {
        int n = this.attemptLimit;
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            By by = this.loadMoreEntriesLocator;
            Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"loadMoreEntriesLocator");
            if (!WebDriverUtils.isElementPresent(this.driver, by)) {
                return this;
            }
            WebElement loadMoreButton = this.driver.findElement(this.loadMoreEntriesLocator);
            new Actions(this.driver).keyDown((CharSequence)Keys.SHIFT).click(loadMoreButton).keyUp((CharSequence)Keys.SHIFT).build().perform();
            ExpectedCondition expectedCondition = ExpectedConditions.invisibilityOfElementLocated((By)By.xpath((String)"//button[@aria-busy='true']"));
            Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"invisibilityOfElementLoc\u2026ton[@aria-busy='true']\"))");
            WebDriverUtils.wait(this.driver, expectedCondition);
        }
        return this;
    }

    public HistoryTabPanel(@NotNull WebDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.driver = driver;
        this.loadMoreEntriesLocator = By.cssSelector((String)"button.show-more-changehistory-tabpanel");
        this.attemptLimit = 5;
    }
}

