/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.tools.jiraactions.api.memories.Comment;
import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import com.atlassian.performance.tools.jiraactions.page.WebElementExtensionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0000J\b\u0010\u0014\u001a\u00020\u0000H\u0002J\b\u0010\u0015\u001a\u00020\u0000H\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/CommentTabPanel;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "(Lorg/openqa/selenium/WebDriver;)V", "attemptLimit", "", "getDriver", "()Lorg/openqa/selenium/WebDriver;", "loadMoreCommentsJira8Locator", "Lorg/openqa/selenium/By;", "loadMoreCommentsJira9Locator", "logger", "Lorg/apache/logging/log4j/Logger;", "getComments", "", "Lcom/atlassian/performance/tools/jiraactions/api/memories/Comment;", "getIssueKey", "", "showAllComments", "showAllCommentsInJira8", "showAllCommentsInJira9", "validateCommentIsFocused", "commentId", "waitForActive", "jira-actions"})
public final class CommentTabPanel {
    private final Logger logger;
    private final By loadMoreCommentsJira8Locator;
    private final By loadMoreCommentsJira9Locator;
    private final int attemptLimit = 5;
    @NotNull
    private final WebDriver driver;

    @NotNull
    public final CommentTabPanel waitForActive() {
        WebElement webElement = this.driver.findElement(By.id((String)"comment-tabpanel"));
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(By.id(\"comment-tabpanel\"))");
        WebElementExtensionKt.scrollIntoView(webElement, this.driver).click();
        ExpectedCondition expectedCondition = ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)"#comment-tabpanel.active"));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"presenceOfElementLocated\u2026omment-tabpanel.active\"))");
        WebDriverUtils.wait(this.driver, expectedCondition);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Comment> getComments() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List comments;
        List list = comments = this.driver.findElements(By.cssSelector((String)"#issue_actions_container > div.activity-comment"));
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"comments");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String url;
            void it;
            WebElement webElement = (WebElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getAttribute("id");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.getAttribute(\"id\")");
            String id = (String)StringsKt.split$default((CharSequence)string, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null).get(1);
            String string2 = url = it.findElement(By.cssSelector((String)".action-head a[href^=\"/browse/\"]")).getAttribute("href");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url");
            Comment comment = new Comment(id, string2);
            collection.add(comment);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final CommentTabPanel validateCommentIsFocused(@NotNull String commentId) {
        Intrinsics.checkParameterIsNotNull((Object)commentId, (String)"commentId");
        ExpectedCondition expectedCondition = ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)("#comment-" + commentId + ".focused")));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"visibilityOfElementLocat\u2026ent-$commentId.focused\"))");
        WebDriverUtils.wait(this.driver, expectedCondition);
        return this;
    }

    @NotNull
    public final String getIssueKey() {
        String string = this.driver.findElement(By.cssSelector((String)"a.issue-link")).getAttribute("data-issue-key");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"driver.findElement(By.cs\u2026tribute(\"data-issue-key\")");
        return string;
    }

    @NotNull
    public final CommentTabPanel showAllComments() {
        if (WebDriverUtils.isElementPresent(this.driver, this.loadMoreCommentsJira8Locator)) {
            return this.showAllCommentsInJira8();
        }
        if (WebDriverUtils.isElementPresent(this.driver, this.loadMoreCommentsJira9Locator)) {
            return this.showAllCommentsInJira9();
        }
        this.logger.debug("The number of comments is less than ten or this Jira version is not supported.");
        return this;
    }

    private final CommentTabPanel showAllCommentsInJira8() {
        WebElement loadMoreButton = this.driver.findElement(this.loadMoreCommentsJira8Locator);
        loadMoreButton.click();
        ExpectedCondition expectedCondition = ExpectedConditions.stalenessOf((WebElement)loadMoreButton);
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"stalenessOf(loadMoreButton)");
        WebDriverUtils.wait(this.driver, expectedCondition);
        return this;
    }

    private final CommentTabPanel showAllCommentsInJira9() {
        int n = this.attemptLimit;
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            if (!WebDriverUtils.isElementPresent(this.driver, this.loadMoreCommentsJira9Locator)) {
                return this;
            }
            WebElement loadMoreButton = this.driver.findElement(this.loadMoreCommentsJira9Locator);
            new Actions(this.driver).keyDown((CharSequence)Keys.SHIFT).click(loadMoreButton).keyUp((CharSequence)Keys.SHIFT).build().perform();
            ExpectedCondition expectedCondition = ExpectedConditions.stalenessOf((WebElement)loadMoreButton);
            Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"stalenessOf(loadMoreButton)");
            WebDriverUtils.wait(this.driver, expectedCondition);
        }
        return this;
    }

    @NotNull
    public final WebDriver getDriver() {
        return this.driver;
    }

    public CommentTabPanel(@NotNull WebDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.driver = driver;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        By by = By.cssSelector((String)"a.show-more-comments");
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.cssSelector(\"a.show-more-comments\")");
        this.loadMoreCommentsJira8Locator = by;
        By by2 = By.cssSelector((String)"button.show-more-comment-tabpanel");
        Intrinsics.checkExpressionValueIsNotNull((Object)by2, (String)"By.cssSelector(\"button.s\u2026w-more-comment-tabpanel\")");
        this.loadMoreCommentsJira9Locator = by2;
        this.attemptLimit = 5;
    }
}

