/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.tools.jiraactions.api.page.IssuePage;
import com.atlassian.performance.tools.jiraactions.api.page.JiraErrors;
import com.atlassian.performance.tools.jiraactions.api.page.RichTextEditorTextArea;
import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/CommentForm;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "(Lorg/openqa/selenium/WebDriver;)V", "submitLocator", "Lorg/openqa/selenium/By;", "kotlin.jvm.PlatformType", "enterCommentText", "comment", "", "submit", "Lcom/atlassian/performance/tools/jiraactions/api/page/IssuePage;", "waitForButton", "jira-actions"})
public final class CommentForm {
    private final By submitLocator;
    private final WebDriver driver;

    @NotNull
    public final CommentForm waitForButton() {
        JiraErrors jiraErrors = new JiraErrors(this.driver);
        ExpectedCondition expectedCondition = ExpectedConditions.or((ExpectedCondition[])new ExpectedCondition[]{ExpectedConditions.presenceOfElementLocated((By)this.submitLocator), jiraErrors.anyCommonError()});
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"or(\n                pres\u2026mmonError()\n            )");
        WebDriverUtils.wait(this.driver, expectedCondition);
        jiraErrors.assertNoErrors();
        WebDriverUtils.tolerateDirtyFormsOnCurrentPage(this.driver);
        return this;
    }

    @NotNull
    public final IssuePage submit() {
        this.driver.findElement(this.submitLocator).click();
        return new IssuePage(this.driver);
    }

    @NotNull
    public final CommentForm enterCommentText(@NotNull String comment) {
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        WebElement webElement = this.driver.findElement(By.id((String)"comment"));
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(By.id(\"comment\"))");
        new RichTextEditorTextArea(this.driver, webElement).overwriteIfPresent(comment);
        return this;
    }

    public CommentForm(@NotNull WebDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.driver = driver;
        this.submitLocator = By.id((String)"comment-add-submit");
    }
}

