/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.seleniumjs.NativeExpectedCondition;
import com.atlassian.performance.seleniumjs.NativeExpectedConditions;
import com.atlassian.performance.tools.jiraactions.api.memories.Project;
import com.atlassian.performance.tools.jiraactions.api.page.JiraErrors;
import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0006\u0010\u0014\u001a\u00020\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/BrowseProjectsPage;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "(Lorg/openqa/selenium/WebDriver;)V", "nextPageLocator", "Lorg/openqa/selenium/By;", "kotlin.jvm.PlatformType", "getNextPage", "", "()Ljava/lang/Integer;", "getNextPageElement", "Lorg/openqa/selenium/WebElement;", "getProjects", "", "Lcom/atlassian/performance/tools/jiraactions/api/memories/Project;", "hasNextPage", "", "isNextPageEnabled", "element", "waitForProjectList", "jira-actions"})
public final class BrowseProjectsPage {
    private final By nextPageLocator;
    private final WebDriver driver;

    @NotNull
    public final BrowseProjectsPage waitForProjectList() {
        JiraErrors jiraErrors = new JiraErrors(this.driver);
        NativeExpectedCondition[] nativeExpectedConditionArray = new NativeExpectedCondition[3];
        By by = By.cssSelector((String)"tbody.projects-list");
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.cssSelector(\"tbody.projects-list\")");
        nativeExpectedConditionArray[0] = NativeExpectedConditions.Companion.presenceOfElementLocated(by);
        By by2 = By.className((String)"none-panel");
        Intrinsics.checkExpressionValueIsNotNull((Object)by2, (String)"By.className(\"none-panel\")");
        nativeExpectedConditionArray[1] = NativeExpectedConditions.Companion.presenceOfElementLocated(by2);
        nativeExpectedConditionArray[2] = jiraErrors.anyCommonErrorNative();
        WebDriverUtils.wait$default(this.driver, null, NativeExpectedConditions.Companion.or(nativeExpectedConditionArray), null, 5, null);
        jiraErrors.assertNoErrors();
        return this;
    }

    private final boolean hasNextPage() {
        WebElement element = this.getNextPageElement();
        return element != null && this.isNextPageEnabled(element);
    }

    private final WebElement getNextPageElement() {
        WebElement webElement;
        List elements = this.driver.findElements(this.nextPageLocator);
        switch (elements.size()) {
            case 1: {
                List list = elements;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"elements");
                webElement = (WebElement)CollectionsKt.first((List)list);
                break;
            }
            case 0: {
                webElement = null;
                break;
            }
            default: {
                throw (Throwable)new Exception("Unexpected state: BrowseProjects page contains more than 1 'Next page' elements");
            }
        }
        return webElement;
    }

    private final boolean isNextPageEnabled(WebElement element) {
        String string;
        String string2 = element.getAttribute("aria-disabled");
        return string2 != null ? !Boolean.parseBoolean(string = string2) : true;
    }

    @Nullable
    public final Integer getNextPage() {
        if (!this.hasNextPage()) {
            return null;
        }
        WebElement projects = this.driver.findElement(this.nextPageLocator);
        String attribute = projects.getAttribute("href");
        Regex regex = new Regex("page=([0-9]+)");
        String string = attribute;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attribute");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult == null) {
            Intrinsics.throwNpe();
        }
        String string2 = (String)CollectionsKt.last((List)matchResult.getGroupValues());
        return Integer.parseInt(string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Project> getProjects() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List projects;
        List list = projects = this.driver.findElements(By.cssSelector((String)".projects-list tr"));
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"projects");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String projectKey;
            String string;
            void it;
            WebElement webElement = (WebElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            WebElement webElement2 = it.findElement(By.cssSelector((String)"td.cell-type-name a"));
            Intrinsics.checkExpressionValueIsNotNull((Object)webElement2, (String)"it.findElement(By.cssSel\u2026r(\"td.cell-type-name a\"))");
            Intrinsics.checkExpressionValueIsNotNull((Object)webElement2.getText(), (String)"it.findElement(By.cssSel\u2026.cell-type-name a\")).text");
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String projectName = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            WebElement webElement3 = it.findElement(By.cssSelector((String)"td.cell-type-key, td.cell-type-name+td"));
            Intrinsics.checkExpressionValueIsNotNull((Object)webElement3, (String)"it.findElement(By.cssSel\u2026, td.cell-type-name+td\"))");
            String string3 = projectKey = webElement3.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"projectKey");
            Project project2 = new Project(string3, projectName);
            collection.add(project2);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public BrowseProjectsPage(@NotNull WebDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.driver = driver;
        this.nextPageLocator = By.cssSelector((String)".aui-nav-next a");
    }
}

