/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.tools.jiraactions.Patience;
import com.atlassian.performance.tools.jiraactions.api.WebJira;
import com.atlassian.performance.tools.jiraactions.api.page.DashboardPage;
import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import com.atlassian.performance.tools.jiraactions.api.webdriver.HardenedKeyboardKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0012J\u001b\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/AdminAccess;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "jira", "Lcom/atlassian/performance/tools/jiraactions/api/WebJira;", "password", "", "(Lorg/openqa/selenium/WebDriver;Lcom/atlassian/performance/tools/jiraactions/api/WebJira;Ljava/lang/String;)V", "dropAdminRightsLocator", "Lorg/openqa/selenium/By;", "kotlin.jvm.PlatformType", "passwordLocator", "drop", "", "gain", "gainProactively", "isDropNotificationPresent", "", "isGranted", "isPrompted", "runWithAccess", "runnable", "Lkotlin/Function0;", "runWithAccess$jira_actions", "jira-actions"})
public final class AdminAccess {
    private final By dropAdminRightsLocator;
    private final By passwordLocator;
    private final WebDriver driver;
    private final WebJira jira;
    private final String password;

    public final boolean isPrompted() {
        if (this.isDropNotificationPresent()) {
            return false;
        }
        return new Patience(null, 1, null).test((Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ AdminAccess this$0;

            public final boolean invoke() {
                WebDriver webDriver = AdminAccess.access$getDriver$p(this.this$0);
                By by = AdminAccess.access$getPasswordLocator$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"passwordLocator");
                return WebDriverUtils.isElementPresent(webDriver, by);
            }
            {
                this.this$0 = adminAccess;
                super(0);
            }
        }));
    }

    public final boolean isGranted() {
        if (this.isDropNotificationPresent()) {
            return true;
        }
        this.jira.goToSystemInfo();
        boolean granted = !this.isPrompted();
        this.driver.navigate().back();
        return granted;
    }

    public final void gainProactively() {
        this.jira.goToSystemInfo();
        this.gain();
        WebDriver.Navigation navigation = this.driver.navigate();
        navigation.back();
        navigation.back();
    }

    public final void gain() {
        WebElement webElement = this.driver.findElement(this.passwordLocator);
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(passwordLocator)");
        HardenedKeyboardKt.sendKeysWhenClickable(webElement, this.driver, this.password);
        this.driver.findElement(By.id((String)"login-form-submit")).click();
    }

    public final void drop() {
        if (!this.isDropNotificationPresent()) {
            this.jira.goToDashboard().waitForDashboard();
            if (!this.isGranted()) {
                return;
            }
        }
        ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((By)this.dropAdminRightsLocator);
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(dropAdminRightsLocator)");
        ((WebElement)WebDriverUtils.wait(this.driver, expectedCondition)).click();
        new DashboardPage(this.driver).waitForDashboard();
        if (this.isDropNotificationPresent()) {
            throw (Throwable)new Exception("Unexpected state: Admin access was still present after dropping it");
        }
    }

    public final void runWithAccess$jira_actions(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkParameterIsNotNull(runnable, (String)"runnable");
        boolean prompted = this.isPrompted();
        if (prompted) {
            this.gain();
        }
        runnable.invoke();
        if (prompted) {
            this.drop();
        }
    }

    private final boolean isDropNotificationPresent() {
        List list = this.driver.findElements(this.dropAdminRightsLocator);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"driver.findElements(dropAdminRightsLocator)");
        Collection collection = list;
        return !collection.isEmpty();
    }

    public AdminAccess(@NotNull WebDriver driver, @NotNull WebJira jira, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        this.driver = driver;
        this.jira = jira;
        this.password = password;
        this.dropAdminRightsLocator = By.cssSelector((String)"#websudo-drop-from-protected-page, #websudo-drop-from-normal-page");
        this.passwordLocator = By.id((String)"login-form-authenticatePassword");
    }

    @NotNull
    public static final /* synthetic */ WebDriver access$getDriver$p(AdminAccess $this) {
        return $this.driver;
    }

    public static final /* synthetic */ By access$getPasswordLocator$p(AdminAccess $this) {
        return $this.passwordLocator;
    }
}

